/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.profiling.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.core.io.StringRecord;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.profiling.types.InstanceProfilingEvent;

public final class SingleInstanceProfilingEvent
extends InstanceProfilingEvent {
    private String instanceName;

    public SingleInstanceProfilingEvent(int profilingInterval, int ioWaitCPU, int idleCPU, int userCPU, int systemCPU, int hardIrqCPU, int softIrqCPU, long totalMemory, long freeMemory, long bufferedMemory, long cachedMemory, long cachedSwapMemory, long receivedBytes, long transmittedBytes, JobID jobID, long timestamp, long profilingTimestamp, String instanceName) {
        super(profilingInterval, ioWaitCPU, idleCPU, userCPU, systemCPU, hardIrqCPU, softIrqCPU, totalMemory, freeMemory, bufferedMemory, cachedMemory, cachedSwapMemory, receivedBytes, transmittedBytes, jobID, timestamp, profilingTimestamp);
        this.instanceName = instanceName;
    }

    public SingleInstanceProfilingEvent() {
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.instanceName = StringRecord.readString((DataInput)in);
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        StringRecord.writeString((DataOutput)out, (String)this.instanceName);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SingleInstanceProfilingEvent)) {
            return false;
        }
        SingleInstanceProfilingEvent singleInstanceProfilingEvent = (SingleInstanceProfilingEvent)obj;
        return this.instanceName.equals(singleInstanceProfilingEvent.getInstanceName());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

