/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.accumulators;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.InputViewDataInputStreamWrapper;
import org.apache.flink.core.memory.OutputViewDataOutputStreamWrapper;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.util.InstantiationUtil;

public class AccumulatorEvent
implements IOReadableWritable {
    private JobID jobID;
    private Map<String, Accumulator<?, ?>> accumulators;
    private String[] accNames;
    private String[] classNames;
    private byte[][] serializedData;

    public AccumulatorEvent() {
        this.accumulators = Collections.emptyMap();
    }

    public AccumulatorEvent(JobID jobID, Map<String, Accumulator<?, ?>> accumulators) {
        this.accumulators = accumulators;
        this.jobID = jobID;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public Map<String, Accumulator<?, ?>> getAccumulators(ClassLoader loader) {
        if (loader == null) {
            throw new NullPointerException();
        }
        if (this.accumulators == null) {
            int num = this.accNames.length;
            this.accumulators = new HashMap(num);
            for (int i = 0; i < num; ++i) {
                Accumulator acc;
                try {
                    Class<?> valClass = Class.forName(this.classNames[i], true, loader);
                    acc = (Accumulator)InstantiationUtil.instantiate(valClass, Accumulator.class);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Could not load user-defined class '" + this.classNames[i] + "'.", e);
                }
                catch (ClassCastException e) {
                    throw new RuntimeException("User-defined accumulator class is not an Accumulator sublass.");
                }
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.serializedData[i]));
                try {
                    acc.read((DataInputView)new InputViewDataInputStreamWrapper(in));
                    in.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while deserializing the user-defined aggregate class.", e);
                }
                this.accumulators.put(this.accNames[i], acc);
            }
            this.accNames = null;
            this.classNames = null;
            this.serializedData = null;
        }
        return this.accumulators;
    }

    public void write(DataOutputView out) throws IOException {
        this.jobID.write(out);
        out.writeInt(this.accumulators.size());
        if (this.accumulators.size() > 0) {
            ByteArrayOutputStream boas = new ByteArrayOutputStream();
            DataOutputStream bufferStream = new DataOutputStream(boas);
            for (Map.Entry<String, Accumulator<?, ?>> entry : this.accumulators.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeUTF(entry.getValue().getClass().getName());
                entry.getValue().write((DataOutputView)new OutputViewDataOutputStreamWrapper(bufferStream));
                bufferStream.flush();
                byte[] bytes = boas.toByteArray();
                out.writeInt(bytes.length);
                out.write(bytes);
                boas.reset();
            }
            bufferStream.close();
            boas.close();
        }
    }

    public void read(DataInputView in) throws IOException {
        this.accumulators = null;
        this.jobID = new JobID();
        this.jobID.read(in);
        int numberOfMapEntries = in.readInt();
        this.accNames = new String[numberOfMapEntries];
        this.classNames = new String[numberOfMapEntries];
        this.serializedData = new byte[numberOfMapEntries][];
        for (int i = 0; i < numberOfMapEntries; ++i) {
            this.accNames[i] = in.readUTF();
            this.classNames[i] = in.readUTF();
            int len = in.readInt();
            byte[] data = new byte[len];
            this.serializedData[i] = data;
            in.readFully(data);
        }
    }
}

