/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.core.fs.BlockLocation;

public final class DistributedBlockLocation
implements BlockLocation {
    private static final char DOMAIN_SEPARATOR = '.';
    private static final Pattern IPV4_PATTERN = Pattern.compile("^\\d+\\.\\d+\\.\\d+\\.\\d+$");
    private final org.apache.hadoop.fs.BlockLocation blockLocation;
    private String[] hostnames;

    public DistributedBlockLocation(org.apache.hadoop.fs.BlockLocation blockLocation) {
        this.blockLocation = blockLocation;
    }

    public String[] getHosts() throws IOException {
        if (this.hostnames == null) {
            String[] hadoopHostnames = this.blockLocation.getHosts();
            this.hostnames = new String[hadoopHostnames.length];
            for (int i = 0; i < hadoopHostnames.length; ++i) {
                this.hostnames[i] = DistributedBlockLocation.stripHostname(hadoopHostnames[i]);
            }
        }
        return this.hostnames;
    }

    private static String stripHostname(String originalHostname) {
        int index = originalHostname.indexOf(46);
        if (index == -1) {
            return originalHostname;
        }
        Matcher matcher = IPV4_PATTERN.matcher(originalHostname);
        if (matcher.matches()) {
            return originalHostname;
        }
        if (index == 0) {
            throw new IllegalStateException("Hostname " + originalHostname + " starts with a " + '.');
        }
        return originalHostname.substring(0, index);
    }

    public long getLength() {
        return this.blockLocation.getLength();
    }

    public long getOffset() {
        return this.blockLocation.getOffset();
    }

    public int compareTo(BlockLocation o) {
        long diff = this.getOffset() - o.getOffset();
        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
    }
}

