/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.Channel;
import org.apache.flink.runtime.io.disk.iomanager.ChannelAccess;
import org.apache.flink.runtime.io.disk.iomanager.IORequest;
import org.apache.flink.runtime.io.disk.iomanager.RequestQueue;

public abstract class BlockChannelAccess<R extends IORequest, C extends Collection<MemorySegment>>
extends ChannelAccess<MemorySegment, R> {
    protected final Object closeLock = new Object();
    protected final AtomicInteger requestsNotReturned = new AtomicInteger(0);
    protected final C returnBuffers;
    protected volatile boolean closed;

    protected BlockChannelAccess(Channel.ID channelID, RequestQueue<R> requestQueue, C returnQueue, boolean writeEnabled) throws IOException {
        super(channelID, requestQueue, writeEnabled);
        if (requestQueue == null) {
            throw new NullPointerException();
        }
        this.returnBuffers = returnQueue;
    }

    public C getReturnQueue() {
        return this.returnBuffers;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                while (this.requestsNotReturned.get() > 0) {
                    try {
                        this.closeLock.wait(1000L);
                        this.checkErroneous();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            finally {
                if (this.fileChannel.isOpen()) {
                    this.fileChannel.close();
                }
            }
        }
    }

    public void closeAndDelete() throws IOException {
        try {
            this.close();
        }
        finally {
            this.deleteChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void returnBuffer(MemorySegment buffer) {
        this.returnBuffers.add((MemorySegment)buffer);
        if (this.closed) {
            Object object = this.closeLock;
            synchronized (object) {
                int num = this.requestsNotReturned.decrementAndGet();
                if (num == 0) {
                    this.closeLock.notifyAll();
                }
            }
        } else {
            this.requestsNotReturned.decrementAndGet();
        }
    }
}

