/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import org.apache.flink.api.common.io.InitializeOnMaster;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.runtime.jobgraph.AbstractJobVertex;
import org.apache.flink.runtime.operators.util.TaskConfig;

public class OutputFormatVertex
extends AbstractJobVertex {
    private static final long serialVersionUID = 1L;
    private transient OutputFormat<?> outputFormat;

    public OutputFormatVertex(String name) {
        super(name);
    }

    @Override
    public void initializeOnMaster(ClassLoader loader) throws Exception {
        if (this.outputFormat == null) {
            TaskConfig cfg = new TaskConfig(this.getConfiguration());
            UserCodeWrapper wrapper = cfg.getStubWrapper(loader);
            if (wrapper == null) {
                throw new Exception("No output format present in OutputFormatVertex's task configuration.");
            }
            this.outputFormat = (OutputFormat)wrapper.getUserCodeObject(OutputFormat.class, loader);
            this.outputFormat.configure(cfg.getStubParameters());
        }
        if (this.outputFormat instanceof InitializeOnMaster) {
            ((InitializeOnMaster)this.outputFormat).initializeGlobal(this.getParallelism());
        }
    }
}

