/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.AbstractID;
import org.apache.flink.runtime.jobgraph.AbstractJobVertex;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class CoLocationGroup
implements Serializable {
    private static final long serialVersionUID = -2605819490401895297L;
    private final AbstractID id = new AbstractID();
    private final List<AbstractJobVertex> vertices = new ArrayList<AbstractJobVertex>();
    private transient ArrayList<CoLocationConstraint> constraints;

    public CoLocationGroup() {
    }

    public CoLocationGroup(AbstractJobVertex ... vertices) {
        for (AbstractJobVertex v : vertices) {
            this.vertices.add(v);
        }
    }

    public void addVertex(AbstractJobVertex vertex) {
        Preconditions.checkNotNull((Object)vertex);
        this.vertices.add(vertex);
    }

    public void mergeInto(CoLocationGroup other) {
        Preconditions.checkNotNull((Object)other);
        for (AbstractJobVertex v : this.vertices) {
            v.updateCoLocationGroup(other);
        }
        other.vertices.addAll(this.vertices);
        this.vertices.clear();
    }

    public CoLocationConstraint getLocationConstraint(int subtask) {
        this.ensureConstraints(subtask + 1);
        return this.constraints.get(subtask);
    }

    public void ensureConstraints(int num) {
        if (this.constraints == null) {
            this.constraints = new ArrayList(num);
        } else {
            this.constraints.ensureCapacity(num);
        }
        if (num > this.constraints.size()) {
            this.constraints.ensureCapacity(num);
            for (int i = this.constraints.size(); i < num; ++i) {
                this.constraints.add(new CoLocationConstraint(this));
            }
        }
    }

    public AbstractID getId() {
        return this.id;
    }
}

