/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.profiling;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.profiling.JobManagerProfiler;
import org.apache.flink.runtime.profiling.TaskManagerProfiler;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilingUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ProfilingUtils.class);
    public static final String ENABLE_PROFILING_KEY = "jobmanager.profiling.enable";
    public static final String JOBMANAGER_CLASSNAME_KEY = "jobmanager.profiling.classname";
    public static final String TASKMANAGER_CLASSNAME_KEY = "taskmanager.profiling.classname";
    public static final String PROFILE_JOB_KEY = "job.profiling.enable";
    public static final String JOBMANAGER_RPC_PORT_KEY = "jobmanager.profiling.rpc.port";
    public static final int JOBMANAGER_DEFAULT_RPC_PORT = 6124;
    public static final String TASKMANAGER_REPORTINTERVAL_KEY = "taskmanager.profiling.reportinterval";
    public static final int DEFAULT_TASKMANAGER_REPORTINTERVAL = 2;

    public static JobManagerProfiler loadJobManagerProfiler(String profilerClassName, InetAddress jobManagerBindAddress) {
        Class<?> profilerClass;
        try {
            profilerClass = Class.forName(profilerClassName);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Cannot find class " + profilerClassName + ": " + StringUtils.stringifyException((Throwable)e));
            return null;
        }
        JobManagerProfiler profiler = null;
        try {
            Constructor<?> constr = profilerClass.getConstructor(InetAddress.class);
            profiler = (JobManagerProfiler)constr.newInstance(jobManagerBindAddress);
        }
        catch (InvocationTargetException e) {
            LOG.error("Cannot create profiler: " + StringUtils.stringifyException((Throwable)e));
            return null;
        }
        catch (NoSuchMethodException e) {
            LOG.error("Cannot create profiler: " + StringUtils.stringifyException((Throwable)e));
            return null;
        }
        catch (InstantiationException e) {
            LOG.error("Cannot create profiler: " + StringUtils.stringifyException((Throwable)e));
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.error("Cannot create profiler: " + StringUtils.stringifyException((Throwable)e));
            return null;
        }
        catch (IllegalArgumentException e) {
            LOG.error("Cannot create profiler: " + StringUtils.stringifyException((Throwable)e));
            return null;
        }
        return profiler;
    }

    public static TaskManagerProfiler loadTaskManagerProfiler(String profilerClassName, InetAddress jobManagerAddress, InstanceConnectionInfo instanceConnectionInfo) {
        Class<?> profilerClass;
        try {
            profilerClass = Class.forName(profilerClassName);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Cannot find class " + profilerClassName + ": " + StringUtils.stringifyException((Throwable)e));
            return null;
        }
        Constructor<?> constructor = null;
        try {
            constructor = profilerClass.getConstructor(InetAddress.class, InstanceConnectionInfo.class);
        }
        catch (SecurityException e1) {
            LOG.error("Security exception while retrieving constructor for class " + profilerClass.getCanonicalName() + ".", (Throwable)e1);
            return null;
        }
        catch (NoSuchMethodException e1) {
            LOG.error("Class " + profilerClass.getCanonicalName() + " does not have a constructor taking a " + "InetAddress and InstanceConnectionInfo parameter.", (Throwable)e1);
            return null;
        }
        TaskManagerProfiler profiler = null;
        try {
            profiler = (TaskManagerProfiler)constructor.newInstance(jobManagerAddress, instanceConnectionInfo);
        }
        catch (IllegalArgumentException e) {
            LOG.error("IllegalArgumentException while creating object of class " + profilerClass.getCanonicalName() + ".", (Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.error("Could not instantiate object of class " + profilerClass.getCanonicalName() + ".", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error("IllegalAccessException while creating object of class " + profilerClass.getCanonicalName() + ".", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error("InvocationTargetException while creating object of class " + profilerClass.getCanonicalName() + ".", (Throwable)e);
        }
        return profiler;
    }
}

