/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.fs.hdfs.DistributedBlockLocation;
import org.apache.flink.runtime.fs.hdfs.DistributedDataInputStream;
import org.apache.flink.runtime.fs.hdfs.DistributedDataOutputStream;
import org.apache.flink.runtime.fs.hdfs.DistributedFileStatus;
import org.apache.flink.util.InstantiationUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DistributedFileSystem
extends FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedFileSystem.class);
    private static final String DEFAULT_HDFS_CLASS = "org.apache.hadoop.hdfs.DistributedFileSystem";
    private static final String HDFS_IMPLEMENTATION_KEY = "fs.hdfs.impl";
    private final Configuration conf;
    private final org.apache.hadoop.fs.FileSystem fs;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DistributedFileSystem() throws IOException {
        Class<org.apache.hadoop.fs.FileSystem> fsClass;
        block17: {
            block18: {
                Class classFromConfig;
                this.conf = DistributedFileSystem.getHadoopConfiguration();
                fsClass = null;
                LOG.debug("Trying to load HDFS class Hadoop 2.x style.");
                Object fsHandle = null;
                try {
                    Method newApi = org.apache.hadoop.fs.FileSystem.class.getMethod("getFileSystemClass", String.class, Configuration.class);
                    fsHandle = newApi.invoke(null, "hdfs", this.conf);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (fsHandle != null) {
                    if (fsHandle instanceof Class && org.apache.hadoop.fs.FileSystem.class.isAssignableFrom((Class)fsHandle)) {
                        fsClass = ((Class)fsHandle).asSubclass(org.apache.hadoop.fs.FileSystem.class);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Loaded '" + fsClass.getName() + "' as HDFS class.");
                        }
                    } else {
                        LOG.debug("Unexpected return type from 'org.apache.hadoop.fs.FileSystem.getFileSystemClass(String, Configuration)'.");
                        throw new RuntimeException("The value returned from org.apache.hadoop.fs.FileSystem.getFileSystemClass(String, Configuration) is not a valid subclass of org.apache.hadoop.fs.FileSystem.");
                    }
                }
                if (fsClass != null) break block17;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Falling back to loading HDFS class old Hadoop style. Looking for HDFS class configuration entry 'fs.hdfs.impl'.");
                }
                if ((classFromConfig = this.conf.getClass(HDFS_IMPLEMENTATION_KEY, null)) == null) break block18;
                if (org.apache.hadoop.fs.FileSystem.class.isAssignableFrom(classFromConfig)) {
                    fsClass = classFromConfig.asSubclass(org.apache.hadoop.fs.FileSystem.class);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Loaded HDFS class '" + fsClass.getName() + "' as specified in configuration.");
                    }
                    break block17;
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("HDFS class specified by fs.hdfs.impl is of wrong type.");
                    }
                    throw new IOException("HDFS class specified by fs.hdfs.impl cannot be cast to a FileSystem type.");
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying to load default HDFS implementation org.apache.hadoop.hdfs.DistributedFileSystem");
            }
            try {
                Class<?> reflectedClass = Class.forName(DEFAULT_HDFS_CLASS);
                if (!org.apache.hadoop.fs.FileSystem.class.isAssignableFrom(reflectedClass)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Default HDFS class is of wrong type.");
                    }
                    throw new IOException("The default HDFS class 'org.apache.hadoop.hdfs.DistributedFileSystem' cannot be cast to a FileSystem type.");
                }
                fsClass = reflectedClass.asSubclass(org.apache.hadoop.fs.FileSystem.class);
            }
            catch (ClassNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Default HDFS class cannot be loaded.");
                }
                throw new IOException("No HDFS class has been configured and the default class 'org.apache.hadoop.hdfs.DistributedFileSystem' cannot be loaded.");
            }
        }
        this.fs = this.instantiateFileSystem(fsClass);
    }

    public static Configuration getHadoopConfiguration() {
        Configuration retConf = new Configuration();
        String hdfsDefaultPath = GlobalConfiguration.getString((String)"fs.hdfs.hdfsdefault", null);
        if (hdfsDefaultPath != null) {
            retConf.addResource(new org.apache.hadoop.fs.Path(hdfsDefaultPath));
        } else {
            LOG.debug("Cannot find hdfs-default configuration file");
        }
        String hdfsSitePath = GlobalConfiguration.getString((String)"fs.hdfs.hdfssite", null);
        if (hdfsSitePath != null) {
            retConf.addResource(new org.apache.hadoop.fs.Path(hdfsSitePath));
        } else {
            LOG.debug("Cannot find hdfs-site configuration file");
        }
        String[] possibleHadoopConfPaths = new String[4];
        possibleHadoopConfPaths[0] = GlobalConfiguration.getString((String)"fs.hdfs.hadoopconf", null);
        possibleHadoopConfPaths[1] = System.getenv("HADOOP_CONF_DIR");
        if (System.getenv("HADOOP_HOME") != null) {
            possibleHadoopConfPaths[2] = System.getenv("HADOOP_HOME") + "/conf";
            possibleHadoopConfPaths[3] = System.getenv("HADOOP_HOME") + "/etc/hadoop";
        }
        for (int i = 0; i < possibleHadoopConfPaths.length; ++i) {
            if (possibleHadoopConfPaths[i] == null || !new File(possibleHadoopConfPaths[i]).exists()) continue;
            if (new File(possibleHadoopConfPaths[i] + "/core-site.xml").exists()) {
                retConf.addResource(new org.apache.hadoop.fs.Path(possibleHadoopConfPaths[i] + "/core-site.xml"));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding " + possibleHadoopConfPaths[i] + "/core-site.xml to hadoop configuration");
                }
            }
            if (!new File(possibleHadoopConfPaths[i] + "/hdfs-site.xml").exists()) continue;
            retConf.addResource(new org.apache.hadoop.fs.Path(possibleHadoopConfPaths[i] + "/hdfs-site.xml"));
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Adding " + possibleHadoopConfPaths[i] + "/hdfs-site.xml to hadoop configuration");
        }
        return retConf;
    }

    private org.apache.hadoop.fs.FileSystem instantiateFileSystem(Class<? extends org.apache.hadoop.fs.FileSystem> fsClass) throws IOException {
        try {
            return fsClass.newInstance();
        }
        catch (ExceptionInInitializerError e) {
            throw new IOException("The filesystem class '" + fsClass.getName() + "' throw an exception upon initialization.", e.getException());
        }
        catch (Throwable t) {
            String errorMessage = InstantiationUtil.checkForInstantiationError(fsClass);
            if (errorMessage != null) {
                throw new IOException("The filesystem class '" + fsClass.getName() + "' cannot be instantiated: " + errorMessage);
            }
            throw new IOException("An error occurred while instantiating the filesystem class '" + fsClass.getName() + "'.", t);
        }
    }

    public Path getWorkingDirectory() {
        return new Path(this.fs.getWorkingDirectory().toUri());
    }

    public URI getUri() {
        return this.fs.getUri();
    }

    public void initialize(URI path) throws IOException {
        block12: {
            if (path.getAuthority() == null) {
                String configEntry = this.conf.get("fs.default.name", null);
                if (configEntry == null) {
                    configEntry = this.conf.get("fs.defaultFS", null);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("fs.defaultFS is set to " + configEntry);
                }
                if (configEntry == null) {
                    throw new IOException(DistributedFileSystem.getMissingAuthorityErrorPrefix(path) + "Either no default hdfs configuration was registered, " + "or that configuration did not contain an entry for the default hdfs.");
                }
                try {
                    URI initURI = URI.create(configEntry);
                    if (initURI.getAuthority() == null) {
                        throw new IOException(DistributedFileSystem.getMissingAuthorityErrorPrefix(path) + "Either no default hdfs configuration was registered, " + "or the provided configuration contains no valid hdfs namenode address (fs.default.name or fs.defaultFS) describing the hdfs namenode host and port.");
                    }
                    if (!initURI.getScheme().equalsIgnoreCase("hdfs")) {
                        throw new IOException(DistributedFileSystem.getMissingAuthorityErrorPrefix(path) + "Either no default hdfs configuration was registered, " + "or the provided configuration describes a file system with scheme '" + initURI.getScheme() + "' other than the Hadoop Distributed File System (HDFS).");
                    }
                    try {
                        this.fs.initialize(initURI, this.conf);
                        break block12;
                    }
                    catch (Exception e) {
                        throw new IOException(DistributedFileSystem.getMissingAuthorityErrorPrefix(path) + "Could not initialize the file system connection with the given address of the HDFS Namenode" + e.getMessage() != null ? ": " + e.getMessage() : ".", e);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new IOException(DistributedFileSystem.getMissingAuthorityErrorPrefix(path) + "The configuration contains an invalid hdfs default name (fs.default.name or fs.defaultFS): " + configEntry);
                }
            }
            try {
                this.fs.initialize(path, this.conf);
            }
            catch (Exception e) {
                throw new IOException("The given file URI (" + path.toString() + ") described the host and port of an HDFS Namenode, but the File System could not be initialized with that address" + (e.getMessage() != null ? ": " + e.getMessage() : "."), e);
            }
        }
    }

    private static final String getMissingAuthorityErrorPrefix(URI path) {
        return "The given HDFS file URI (" + path.toString() + ") did not describe the HDFS Namenode." + " The attempt to use a default HDFS configuration, as specified in the '" + "fs.hdfs.hdfsdefault" + "' or '" + "fs.hdfs.hdfssite" + "' config parameter failed due to the following problem: ";
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        org.apache.hadoop.fs.FileStatus status = this.fs.getFileStatus(new org.apache.hadoop.fs.Path(f.toString()));
        return new DistributedFileStatus(status);
    }

    public org.apache.flink.core.fs.BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (!(file instanceof DistributedFileStatus)) {
            throw new IOException("file is not an instance of DistributedFileStatus");
        }
        DistributedFileStatus f = (DistributedFileStatus)file;
        BlockLocation[] blkLocations = this.fs.getFileBlockLocations(f.getInternalFileStatus(), start, len);
        org.apache.flink.core.fs.BlockLocation[] distBlkLocations = new DistributedBlockLocation[blkLocations.length];
        for (int i = 0; i < distBlkLocations.length; ++i) {
            distBlkLocations[i] = new DistributedBlockLocation(blkLocations[i]);
        }
        return distBlkLocations;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        org.apache.hadoop.fs.FSDataInputStream fdis = this.fs.open(new org.apache.hadoop.fs.Path(f.toString()), bufferSize);
        return new DistributedDataInputStream(fdis);
    }

    public FSDataInputStream open(Path f) throws IOException {
        org.apache.hadoop.fs.FSDataInputStream fdis = this.fs.open(new org.apache.hadoop.fs.Path(f.toString()));
        return new DistributedDataInputStream(fdis);
    }

    public org.apache.flink.core.fs.FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        FSDataOutputStream fdos = this.fs.create(new org.apache.hadoop.fs.Path(f.toString()), overwrite, bufferSize, replication, blockSize);
        return new DistributedDataOutputStream(fdos);
    }

    public org.apache.flink.core.fs.FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
        FSDataOutputStream fdos = this.fs.create(new org.apache.hadoop.fs.Path(f.toString()), overwrite);
        return new DistributedDataOutputStream(fdos);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.fs.delete(new org.apache.hadoop.fs.Path(f.toString()), recursive);
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        org.apache.hadoop.fs.FileStatus[] hadoopFiles = this.fs.listStatus(new org.apache.hadoop.fs.Path(f.toString()));
        FileStatus[] files = new FileStatus[hadoopFiles.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new DistributedFileStatus(hadoopFiles[i]);
        }
        return files;
    }

    public boolean mkdirs(Path f) throws IOException {
        return this.fs.mkdirs(new org.apache.hadoop.fs.Path(f.toString()));
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.fs.rename(new org.apache.hadoop.fs.Path(src.toString()), new org.apache.hadoop.fs.Path(dst.toString()));
    }

    public long getDefaultBlockSize() {
        return this.fs.getDefaultBlockSize();
    }

    public boolean isDistributedFS() {
        return true;
    }
}

