/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.NetUtils;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceConnectionInfo
implements IOReadableWritable,
Comparable<InstanceConnectionInfo>,
Serializable {
    private static final long serialVersionUID = -8254407801276350716L;
    private static final Logger LOG = LoggerFactory.getLogger(InstanceConnectionInfo.class);
    private InetAddress inetAddress;
    private int ipcPort;
    private int dataPort;
    private String fqdnHostName;
    private String hostName;
    private boolean fqdnHostNameIsIP = false;

    public InstanceConnectionInfo(InetAddress inetAddress, int ipcPort, int dataPort) {
        if (inetAddress == null) {
            throw new IllegalArgumentException("Argument inetAddress must not be null");
        }
        if (ipcPort <= 0) {
            throw new IllegalArgumentException("Argument ipcPort must be greater than zero");
        }
        if (dataPort <= 0) {
            throw new IllegalArgumentException("Argument dataPort must be greater than zero");
        }
        if (ipcPort == dataPort) {
            throw new IllegalArgumentException("IPC and data port must be different");
        }
        this.ipcPort = ipcPort;
        this.dataPort = dataPort;
        this.inetAddress = inetAddress;
        try {
            this.fqdnHostName = this.inetAddress.getCanonicalHostName();
        }
        catch (Throwable t) {
            LOG.warn("Unable to determine hostname for TaskManager. The performance might be degraded since HDFS input split assignment is not possible");
            if (LOG.isDebugEnabled()) {
                LOG.debug("getCanonicalHostName() Exception", t);
            }
            this.fqdnHostName = inetAddress.getHostAddress();
            this.fqdnHostNameIsIP = true;
        }
    }

    public InstanceConnectionInfo() {
    }

    public int ipcPort() {
        return this.ipcPort;
    }

    public int dataPort() {
        return this.dataPort;
    }

    public InetAddress address() {
        return this.inetAddress;
    }

    public String getFQDNHostname() {
        return this.fqdnHostName;
    }

    public String getHostname() {
        if (this.hostName == null) {
            String fqdn = this.getFQDNHostname();
            this.hostName = this.fqdnHostNameIsIP ? fqdn : NetUtils.getHostnameFromFQDN((String)fqdn);
        }
        return this.hostName;
    }

    public String getInetAdress() {
        return this.inetAddress.toString();
    }

    public void read(DataInputView in) throws IOException {
        int addr_length = in.readInt();
        byte[] address = new byte[addr_length];
        in.readFully(address);
        this.ipcPort = in.readInt();
        this.dataPort = in.readInt();
        this.fqdnHostName = StringUtils.readNullableString((DataInputView)in);
        this.hostName = StringUtils.readNullableString((DataInputView)in);
        this.fqdnHostNameIsIP = in.readBoolean();
        try {
            this.inetAddress = InetAddress.getByAddress(address);
        }
        catch (UnknownHostException e) {
            throw new IOException("This lookup should never fail.", e);
        }
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.inetAddress.getAddress().length);
        out.write(this.inetAddress.getAddress());
        out.writeInt(this.ipcPort);
        out.writeInt(this.dataPort);
        StringUtils.writeNullableString((String)this.fqdnHostName, (DataOutputView)out);
        StringUtils.writeNullableString((String)this.hostName, (DataOutputView)out);
        out.writeBoolean(this.fqdnHostNameIsIP);
    }

    public String toString() {
        return this.getFQDNHostname() + " (ipcPort=" + this.ipcPort + ", dataPort=" + this.dataPort + ")";
    }

    public boolean equals(Object obj) {
        if (obj instanceof InstanceConnectionInfo) {
            InstanceConnectionInfo other = (InstanceConnectionInfo)obj;
            return this.ipcPort == other.ipcPort && this.dataPort == other.dataPort && this.inetAddress.equals(other.inetAddress);
        }
        return false;
    }

    public int hashCode() {
        return this.inetAddress.hashCode() + 17 * this.ipcPort + 23 * this.dataPort;
    }

    @Override
    public int compareTo(InstanceConnectionInfo o) {
        byte[] otherAddress;
        byte[] thisAddress = this.inetAddress.getAddress();
        if (thisAddress.length < (otherAddress = o.inetAddress.getAddress()).length) {
            return -1;
        }
        if (thisAddress.length > otherAddress.length) {
            return 1;
        }
        for (int i = 0; i < thisAddress.length; ++i) {
            byte tb = thisAddress[i];
            byte ob = otherAddress[i];
            if (tb < ob) {
                return -1;
            }
            if (tb <= ob) continue;
            return 1;
        }
        if (this.ipcPort < o.ipcPort) {
            return -1;
        }
        if (this.ipcPort > o.ipcPort) {
            return 1;
        }
        if (this.dataPort < o.dataPort) {
            return -1;
        }
        if (this.dataPort > o.dataPort) {
            return 1;
        }
        return 0;
    }
}

