/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.serialization;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.network.Buffer;
import org.apache.flink.runtime.io.network.serialization.DataOutputSerializer;
import org.apache.flink.runtime.io.network.serialization.RecordSerializer;

public class SpanningRecordSerializer<T extends IOReadableWritable>
implements RecordSerializer<T> {
    private static final boolean CHECKED = true;
    private final DataOutputSerializer serializationBuffer = new DataOutputSerializer(128);
    private ByteBuffer dataBuffer;
    private final ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
    private Buffer targetBuffer;
    private int position;
    private int limit;

    public SpanningRecordSerializer() {
        this.lengthBuffer.order(ByteOrder.BIG_ENDIAN);
        this.dataBuffer = this.serializationBuffer.wrapAsByteBuffer();
        this.lengthBuffer.position(4);
    }

    @Override
    public RecordSerializer.SerializationResult addRecord(T record) throws IOException {
        if (this.dataBuffer.hasRemaining()) {
            throw new IllegalStateException("Pending serialization of previous record.");
        }
        this.serializationBuffer.clear();
        this.lengthBuffer.clear();
        record.write((DataOutputView)this.serializationBuffer);
        this.lengthBuffer.putInt(0, this.serializationBuffer.length());
        this.dataBuffer = this.serializationBuffer.wrapAsByteBuffer();
        this.copyToTargetBufferFrom(this.lengthBuffer);
        this.copyToTargetBufferFrom(this.dataBuffer);
        return this.getSerializationResult();
    }

    @Override
    public RecordSerializer.SerializationResult setNextBuffer(Buffer buffer) throws IOException {
        this.targetBuffer = buffer;
        this.position = 0;
        this.limit = buffer.size();
        if (this.lengthBuffer.hasRemaining()) {
            this.copyToTargetBufferFrom(this.lengthBuffer);
        }
        if (this.dataBuffer.hasRemaining()) {
            this.copyToTargetBufferFrom(this.dataBuffer);
        }
        return this.getSerializationResult();
    }

    private void copyToTargetBufferFrom(ByteBuffer source) {
        if (this.targetBuffer == null) {
            return;
        }
        int needed = source.remaining();
        int available = this.limit - this.position;
        int toCopy = Math.min(needed, available);
        this.targetBuffer.getMemorySegment().put(this.position, source, toCopy);
        this.position += toCopy;
    }

    private RecordSerializer.SerializationResult getSerializationResult() {
        if (!this.dataBuffer.hasRemaining() && !this.lengthBuffer.hasRemaining()) {
            return this.position < this.limit ? RecordSerializer.SerializationResult.FULL_RECORD : RecordSerializer.SerializationResult.FULL_RECORD_MEMORY_SEGMENT_FULL;
        }
        return RecordSerializer.SerializationResult.PARTIAL_RECORD_MEMORY_SEGMENT_FULL;
    }

    @Override
    public Buffer getCurrentBuffer() {
        if (this.targetBuffer == null) {
            return null;
        }
        this.targetBuffer.limitSize(this.position);
        return this.targetBuffer;
    }

    @Override
    public void clear() {
        this.targetBuffer = null;
        this.position = 0;
        this.limit = 0;
        this.dataBuffer.position(this.dataBuffer.limit());
        this.lengthBuffer.position(4);
    }

    @Override
    public boolean hasData() {
        return this.position > 0 || this.lengthBuffer.hasRemaining() || this.dataBuffer.hasRemaining();
    }
}

