/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.runtime.instance.AllocatedSlot;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroupAssignment;
import org.apache.flink.runtime.jobmanager.scheduler.SubSlot;

class SharedSlot {
    private final AllocatedSlot allocatedSlot;
    private final SlotSharingGroupAssignment assignmentGroup;
    private final Set<SubSlot> subSlots;
    private int subSlotNumber;
    private volatile boolean disposed;

    public SharedSlot(AllocatedSlot allocatedSlot, SlotSharingGroupAssignment assignmentGroup) {
        if (allocatedSlot == null || assignmentGroup == null) {
            throw new NullPointerException();
        }
        this.allocatedSlot = allocatedSlot;
        this.assignmentGroup = assignmentGroup;
        this.subSlots = new HashSet<SubSlot>();
    }

    AllocatedSlot getAllocatedSlot() {
        return this.allocatedSlot;
    }

    boolean isDisposed() {
        return this.disposed;
    }

    int getNumberOfAllocatedSubSlots() {
        return this.subSlots.size();
    }

    SubSlot allocateSubSlot(JobVertexID jid) {
        if (this.disposed) {
            return null;
        }
        SubSlot ss = new SubSlot(this, this.subSlotNumber++, jid);
        this.subSlots.add(ss);
        return ss;
    }

    void returnAllocatedSlot(SubSlot slot) {
        if (!slot.isReleased()) {
            throw new IllegalArgumentException("SubSlot is not released.");
        }
        this.assignmentGroup.releaseSubSlot(slot, this);
    }

    int releaseSlot(SubSlot slot) {
        if (!this.subSlots.remove(slot)) {
            throw new IllegalArgumentException("Wrong shared slot for subslot.");
        }
        return this.subSlots.size();
    }

    void dispose() {
        if (!this.subSlots.isEmpty()) {
            throw new IllegalStateException("Cannot dispose while subslots are still alive.");
        }
        this.disposed = true;
        this.allocatedSlot.releaseSlot();
    }

    public String toString() {
        return "Shared " + this.allocatedSlot.toString();
    }
}

