/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution.librarycache;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlobLibraryCacheManager
extends TimerTask
implements LibraryCacheManager {
    private static Logger LOG = LoggerFactory.getLogger(BlobLibraryCacheManager.class);
    private static ExecutionAttemptID JOB_ATTEMPT_ID = new ExecutionAttemptID();
    private final Object lockObject = new Object();
    private final Map<JobID, LibraryCacheEntry> cacheEntries = new HashMap<JobID, LibraryCacheEntry>();
    private final Map<BlobKey, Integer> blobKeyReferenceCounters = new HashMap<BlobKey, Integer>();
    private final BlobService blobService;

    public BlobLibraryCacheManager(BlobService blobService, Configuration configuration) {
        this.blobService = blobService;
        Timer timer = new Timer(true);
        long cleanupInterval = configuration.getLong("library-cache-manager.cleanup.interval", 3600L) * 1000L;
        timer.schedule((TimerTask)this, cleanupInterval);
    }

    @Override
    public void registerJob(JobID id, Collection<BlobKey> requiredJarFiles) throws IOException {
        this.registerTask(id, JOB_ATTEMPT_ID, requiredJarFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTask(JobID jobId, ExecutionAttemptID task, Collection<BlobKey> requiredJarFiles) throws IOException {
        Preconditions.checkNotNull((Object)jobId, (Object)"The JobId must not be null.");
        Preconditions.checkNotNull((Object)task, (Object)"The task execution id must not be null.");
        if (requiredJarFiles == null) {
            requiredJarFiles = Collections.emptySet();
        }
        Object object = this.lockObject;
        synchronized (object) {
            LibraryCacheEntry entry = this.cacheEntries.get(jobId);
            if (entry == null) {
                URL[] urls = new URL[requiredJarFiles.size()];
                int count = 0;
                for (BlobKey blobKey : requiredJarFiles) {
                    urls[count++] = this.registerReferenceToBlobKeyAndGetURL(blobKey);
                }
                URLClassLoader classLoader = new URLClassLoader(urls);
                this.cacheEntries.put(jobId, new LibraryCacheEntry(requiredJarFiles, classLoader, task));
            } else {
                entry.register(task, requiredJarFiles);
            }
        }
    }

    @Override
    public void unregisterJob(JobID id) {
        this.unregisterTask(id, JOB_ATTEMPT_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterTask(JobID jobId, ExecutionAttemptID task) {
        Preconditions.checkNotNull((Object)jobId, (Object)"The JobId must not be null.");
        Preconditions.checkNotNull((Object)task, (Object)"The task execution id must not be null.");
        Object object = this.lockObject;
        synchronized (object) {
            LibraryCacheEntry entry = this.cacheEntries.get(jobId);
            if (entry != null && entry.unregister(task)) {
                this.cacheEntries.remove(jobId);
                for (BlobKey key : entry.getLibraries()) {
                    this.unregisterReferenceToBlobKey(key);
                }
            }
        }
    }

    @Override
    public ClassLoader getClassLoader(JobID id) {
        if (id == null) {
            throw new IllegalArgumentException("The JobId must not be null.");
        }
        Object object = this.lockObject;
        synchronized (object) {
            LibraryCacheEntry entry = this.cacheEntries.get(id);
            if (entry != null) {
                return entry.getClassLoader();
            }
            throw new IllegalStateException("No libraries are registered for job " + id);
        }
    }

    @Override
    public File getFile(BlobKey blobKey) throws IOException {
        return new File(this.blobService.getURL(blobKey).getFile());
    }

    public int getBlobServerPort() {
        return this.blobService.getPort();
    }

    @Override
    public void shutdown() throws IOException {
        this.blobService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.lockObject;
        synchronized (object) {
            Iterator<Map.Entry<BlobKey, Integer>> entryIter = this.blobKeyReferenceCounters.entrySet().iterator();
            while (entryIter.hasNext()) {
                Map.Entry<BlobKey, Integer> entry = entryIter.next();
                BlobKey key = entry.getKey();
                int references = entry.getValue();
                try {
                    if (references > 0) continue;
                    this.blobService.delete(key);
                    entryIter.remove();
                }
                catch (Throwable t) {
                    LOG.warn("Could not delete file with blob key" + key, t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfReferenceHolders(JobID jobId) {
        Object object = this.lockObject;
        synchronized (object) {
            LibraryCacheEntry entry = this.cacheEntries.get(jobId);
            return entry == null ? 0 : entry.getNumberOfReferenceHolders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfCachedLibraries() {
        Object object = this.lockObject;
        synchronized (object) {
            return this.blobKeyReferenceCounters.size();
        }
    }

    private URL registerReferenceToBlobKeyAndGetURL(BlobKey key) throws IOException {
        Integer references = this.blobKeyReferenceCounters.get(key);
        int newReferences = references == null ? 1 : references + 1;
        this.blobKeyReferenceCounters.put(key, newReferences);
        return this.blobService.getURL(key);
    }

    private void unregisterReferenceToBlobKey(BlobKey key) {
        Integer references = this.blobKeyReferenceCounters.get(key);
        if (references != null) {
            int newReferences = Math.max(references - 1, 0);
            this.blobKeyReferenceCounters.put(key, newReferences);
        }
    }

    private static class LibraryCacheEntry {
        private final ClassLoader classLoader;
        private final Set<ExecutionAttemptID> referenceHolders;
        private final Set<BlobKey> libraries;

        public LibraryCacheEntry(Collection<BlobKey> libraries, ClassLoader classLoader, ExecutionAttemptID initialReference) {
            this.classLoader = classLoader;
            this.libraries = new HashSet<BlobKey>(libraries);
            this.referenceHolders = new HashSet<ExecutionAttemptID>();
            this.referenceHolders.add(initialReference);
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public Set<BlobKey> getLibraries() {
            return this.libraries;
        }

        public void register(ExecutionAttemptID task, Collection<BlobKey> keys) {
            if (!this.libraries.containsAll(keys)) {
                throw new IllegalStateException("The library registration references a different set of libraries than previous registrations for this job.");
            }
            this.referenceHolders.add(task);
        }

        public boolean unregister(ExecutionAttemptID task) {
            this.referenceHolders.remove(task);
            return this.referenceHolders.isEmpty();
        }

        public int getNumberOfReferenceHolders() {
            return this.referenceHolders.size();
        }
    }
}

