/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.AbstractFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IORequest;
import org.apache.flink.runtime.io.disk.iomanager.RequestDoneCallback;
import org.apache.flink.runtime.io.disk.iomanager.RequestQueue;

public abstract class AsynchronousFileIOChannel<R extends IORequest>
extends AbstractFileIOChannel {
    protected final Object closeLock = new Object();
    protected final RequestQueue<R> requestQueue;
    protected final AtomicInteger requestsNotReturned = new AtomicInteger(0);
    protected final RequestDoneCallback resultHander;
    protected volatile IOException exception;
    protected volatile boolean closed;

    protected AsynchronousFileIOChannel(FileIOChannel.ID channelID, RequestQueue<R> requestQueue, RequestDoneCallback callback, boolean writeEnabled) throws IOException {
        super(channelID, writeEnabled);
        if (requestQueue == null) {
            throw new NullPointerException();
        }
        this.requestQueue = requestQueue;
        this.resultHander = callback;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                while (this.requestsNotReturned.get() > 0) {
                    try {
                        this.closeLock.wait(1000L);
                        this.checkErroneous();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            finally {
                if (this.fileChannel.isOpen()) {
                    this.fileChannel.close();
                }
            }
        }
    }

    @Override
    public void closeAndDelete() throws IOException {
        try {
            this.close();
        }
        finally {
            this.deleteChannel();
        }
    }

    public final void checkErroneous() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void handleProcessedBuffer(MemorySegment buffer, IOException ex) {
        try {
            if (ex != null && this.exception == null) {
                this.exception = ex;
                this.resultHander.requestFailed(buffer, ex);
            } else {
                this.resultHander.requestSuccessful(buffer);
            }
        }
        finally {
            if (this.closed) {
                Object object = this.closeLock;
                synchronized (object) {
                    int num = this.requestsNotReturned.decrementAndGet();
                    if (num == 0) {
                        this.closeLock.notifyAll();
                    }
                }
            } else {
                this.requestsNotReturned.decrementAndGet();
            }
        }
    }
}

