/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.serialization;

import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemoryUtils;
import sun.misc.Unsafe;

public class DataOutputSerializer
implements DataOutputView {
    private byte[] buffer;
    private int position;
    private ByteBuffer wrapper;
    private static final Unsafe UNSAFE = MemoryUtils.UNSAFE;
    private static final long BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    private static final boolean LITTLE_ENDIAN = MemoryUtils.NATIVE_BYTE_ORDER == ByteOrder.LITTLE_ENDIAN;

    public DataOutputSerializer(int startSize) {
        if (startSize < 1) {
            throw new IllegalArgumentException();
        }
        this.buffer = new byte[startSize];
        this.wrapper = ByteBuffer.wrap(this.buffer);
    }

    public ByteBuffer wrapAsByteBuffer() {
        this.wrapper.position(0);
        this.wrapper.limit(this.position);
        return this.wrapper;
    }

    public void clear() {
        this.position = 0;
    }

    public int length() {
        return this.position;
    }

    public String toString() {
        return String.format("[pos=%d cap=%d]", this.position, this.buffer.length);
    }

    public void write(int b) throws IOException {
        if (this.position >= this.buffer.length) {
            this.resize(1);
        }
        this.buffer[this.position++] = (byte)(b & 0xFF);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.position > this.buffer.length - len) {
            this.resize(len);
        }
        System.arraycopy(b, off, this.buffer, this.position, len);
        this.position += len;
    }

    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    public void writeBytes(String s) throws IOException {
        int sLen = s.length();
        if (this.position >= this.buffer.length - sLen) {
            this.resize(sLen);
        }
        for (int i = 0; i < sLen; ++i) {
            this.writeByte(s.charAt(i));
        }
        this.position += sLen;
    }

    public void writeChar(int v) throws IOException {
        if (this.position >= this.buffer.length - 1) {
            this.resize(2);
        }
        this.buffer[this.position++] = (byte)(v >> 8);
        this.buffer[this.position++] = (byte)v;
    }

    public void writeChars(String s) throws IOException {
        int sLen = s.length();
        if (this.position >= this.buffer.length - 2 * sLen) {
            this.resize(2 * sLen);
        }
        for (int i = 0; i < sLen; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeInt(int v) throws IOException {
        if (this.position >= this.buffer.length - 3) {
            this.resize(4);
        }
        if (LITTLE_ENDIAN) {
            v = Integer.reverseBytes(v);
        }
        UNSAFE.putInt(this.buffer, BASE_OFFSET + (long)this.position, v);
        this.position += 4;
    }

    public void writeLong(long v) throws IOException {
        if (this.position >= this.buffer.length - 7) {
            this.resize(8);
        }
        if (LITTLE_ENDIAN) {
            v = Long.reverseBytes(v);
        }
        UNSAFE.putLong(this.buffer, BASE_OFFSET + (long)this.position, v);
        this.position += 8;
    }

    public void writeShort(int v) throws IOException {
        if (this.position >= this.buffer.length - 1) {
            this.resize(2);
        }
        this.buffer[this.position++] = (byte)(v >>> 8 & 0xFF);
        this.buffer[this.position++] = (byte)(v >>> 0 & 0xFF);
    }

    public void writeUTF(String str) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("Encoded string is too long: " + utflen);
        }
        if (this.position > this.buffer.length - utflen - 2) {
            this.resize(utflen + 2);
        }
        byte[] bytearr = this.buffer;
        int count = this.position;
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        int i = 0;
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        this.position = count;
    }

    private void resize(int minCapacityAdd) throws IOException {
        try {
            int newLen = Math.max(this.buffer.length * 2, this.buffer.length + minCapacityAdd);
            byte[] nb = new byte[newLen];
            System.arraycopy(this.buffer, 0, nb, 0, this.position);
            this.buffer = nb;
            this.wrapper = ByteBuffer.wrap(this.buffer);
        }
        catch (NegativeArraySizeException nasex) {
            throw new IOException("Serialization failed because the record length would exceed 2GB (max addressable array size in Java).");
        }
    }

    public void skipBytesToWrite(int numBytes) throws IOException {
        if (this.buffer.length - this.position < numBytes) {
            throw new EOFException("Could not skip " + numBytes + " bytes.");
        }
        this.position += numBytes;
    }

    public void write(DataInputView source, int numBytes) throws IOException {
        if (this.buffer.length - this.position < numBytes) {
            throw new EOFException("Could not write " + numBytes + " bytes. Buffer overflow.");
        }
        source.read(this.buffer, this.position, numBytes);
        this.position += numBytes;
    }
}

