/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import org.apache.flink.runtime.AbstractID;
import org.apache.flink.runtime.instance.AllocatedSlot;
import org.apache.flink.runtime.jobmanager.scheduler.SharedSlot;

public class SubSlot
extends AllocatedSlot {
    private final SharedSlot sharedSlot;
    private final AbstractID groupId;
    private final int subSlotNumber;

    public SubSlot(SharedSlot sharedSlot, int subSlotNumber, AbstractID groupId) {
        super(sharedSlot.getAllocatedSlot().getJobID(), sharedSlot.getAllocatedSlot().getInstance(), sharedSlot.getAllocatedSlot().getSlotNumber());
        this.sharedSlot = sharedSlot;
        this.groupId = groupId;
        this.subSlotNumber = subSlotNumber;
    }

    @Override
    public void releaseSlot() {
        try {
            this.cancel();
        }
        finally {
            if (this.markReleased()) {
                this.sharedSlot.returnAllocatedSlot(this);
            }
        }
    }

    public SharedSlot getSharedSlot() {
        return this.sharedSlot;
    }

    public AbstractID getGroupId() {
        return this.groupId;
    }

    @Override
    public String toString() {
        return "SubSlot " + this.subSlotNumber + " (" + super.toString() + ')';
    }
}

