/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.flink.api.common.accumulators.AccumulatorHelper;
import org.apache.flink.runtime.event.job.AbstractEvent;
import org.apache.flink.runtime.event.job.ExecutionStateChangeEvent;
import org.apache.flink.runtime.event.job.JobEvent;
import org.apache.flink.runtime.event.job.RecentJobEvent;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.instance.AllocatedSlot;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.web.JsonFactory;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.StringUtils;
import org.eclipse.jetty.io.EofException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobmanagerInfoServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(JobmanagerInfoServlet.class);
    private final JobManager jobmanager;

    public JobmanagerInfoServlet(JobManager jobmanager) {
        this.jobmanager = jobmanager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block16: {
            resp.setStatus(200);
            resp.setContentType("application/json");
            try {
                if ("archive".equals(req.getParameter("get"))) {
                    this.writeJsonForArchive(resp.getWriter(), this.jobmanager.getOldJobs());
                } else if ("job".equals(req.getParameter("get"))) {
                    String jobId = req.getParameter("job");
                    this.writeJsonForArchivedJob(resp.getWriter(), this.jobmanager.getArchive().getJob(JobID.fromHexString(jobId)));
                } else if ("groupvertex".equals(req.getParameter("get"))) {
                    String jobId = req.getParameter("job");
                    String groupvertexId = req.getParameter("groupvertex");
                    this.writeJsonForArchivedJobGroupvertex(resp.getWriter(), this.jobmanager.getArchive().getJob(JobID.fromHexString(jobId)), JobVertexID.fromHexString(groupvertexId));
                } else if ("taskmanagers".equals(req.getParameter("get"))) {
                    resp.getWriter().write("{\"taskmanagers\": " + this.jobmanager.getNumberOfTaskManagers() + ", \"slots\": " + this.jobmanager.getTotalNumberOfRegisteredSlots() + "}");
                } else if ("cancel".equals(req.getParameter("get"))) {
                    String jobId = req.getParameter("job");
                    this.jobmanager.cancelJob(JobID.fromHexString(jobId));
                } else if ("updates".equals(req.getParameter("get"))) {
                    String jobId = req.getParameter("job");
                    this.writeJsonUpdatesForJob(resp.getWriter(), JobID.fromHexString(jobId));
                } else if ("version".equals(req.getParameter("get"))) {
                    this.writeJsonForVersion(resp.getWriter());
                } else {
                    this.writeJsonForJobs(resp.getWriter(), this.jobmanager.getRecentJobs());
                }
            }
            catch (Exception e) {
                resp.setStatus(400);
                resp.getWriter().print(e.getMessage());
                if (!LOG.isWarnEnabled()) break block16;
                LOG.warn(StringUtils.stringifyException((Throwable)e));
            }
        }
    }

    private void writeJsonForJobs(PrintWriter wrt, List<RecentJobEvent> jobs) {
        try {
            wrt.write("[");
            for (int i = 0; i < jobs.size(); ++i) {
                RecentJobEvent jobEvent = jobs.get(i);
                this.writeJsonForJob(wrt, jobEvent);
                if (i == jobs.size() - 1) continue;
                wrt.write(",");
            }
            wrt.write("]");
        }
        catch (EofException eof) {
            LOG.info("Info server for jobmanager: Connection closed by client, EofException");
        }
        catch (IOException ioe) {
            LOG.info("Info server for jobmanager: Connection closed by client, IOException");
        }
    }

    private void writeJsonForJob(PrintWriter wrt, RecentJobEvent jobEvent) throws IOException {
        ExecutionGraph graph = this.jobmanager.getRecentExecutionGraph(jobEvent.getJobID());
        wrt.write("{");
        wrt.write("\"jobid\": \"" + jobEvent.getJobID() + "\",");
        wrt.write("\"jobname\": \"" + jobEvent.getJobName() + "\",");
        wrt.write("\"status\": \"" + (Object)((Object)jobEvent.getJobStatus()) + "\",");
        wrt.write("\"time\": " + jobEvent.getTimestamp() + ",");
        wrt.write("\"groupvertices\": [");
        boolean first = true;
        for (ExecutionJobVertex groupVertex : graph.getVerticesTopologically()) {
            if (first) {
                first = false;
            } else {
                wrt.write(",");
            }
            wrt.write(JsonFactory.toJson(groupVertex));
        }
        wrt.write("]");
        wrt.write("}");
    }

    private void writeJsonForArchive(PrintWriter wrt, List<RecentJobEvent> jobs) {
        wrt.write("[");
        Collections.sort(jobs, new Comparator<RecentJobEvent>(){

            @Override
            public int compare(RecentJobEvent o1, RecentJobEvent o2) {
                if (o1.getTimestamp() < o2.getTimestamp()) {
                    return 1;
                }
                return -1;
            }
        });
        for (int i = 0; i < jobs.size(); ++i) {
            RecentJobEvent jobEvent = jobs.get(i);
            wrt.write("{");
            wrt.write("\"jobid\": \"" + jobEvent.getJobID() + "\",");
            wrt.write("\"jobname\": \"" + jobEvent.getJobName() + "\",");
            wrt.write("\"status\": \"" + (Object)((Object)jobEvent.getJobStatus()) + "\",");
            wrt.write("\"time\": " + jobEvent.getTimestamp());
            wrt.write("}");
            if (i == jobs.size() - 1) continue;
            wrt.write(",");
        }
        wrt.write("]");
    }

    private void writeJsonForArchivedJob(PrintWriter wrt, RecentJobEvent jobEvent) {
        try {
            boolean first;
            wrt.write("[");
            ExecutionGraph graph = this.jobmanager.getRecentExecutionGraph(jobEvent.getJobID());
            wrt.write("{");
            wrt.write("\"jobid\": \"" + jobEvent.getJobID() + "\",");
            wrt.write("\"jobname\": \"" + jobEvent.getJobName() + "\",");
            wrt.write("\"status\": \"" + (Object)((Object)jobEvent.getJobStatus()) + "\",");
            wrt.write("\"SCHEDULED\": " + graph.getStatusTimestamp(JobStatus.CREATED) + ",");
            wrt.write("\"RUNNING\": " + graph.getStatusTimestamp(JobStatus.RUNNING) + ",");
            wrt.write("\"FINISHED\": " + graph.getStatusTimestamp(JobStatus.FINISHED) + ",");
            wrt.write("\"FAILED\": " + graph.getStatusTimestamp(JobStatus.FAILED) + ",");
            wrt.write("\"CANCELED\": " + graph.getStatusTimestamp(JobStatus.CANCELED) + ",");
            if (jobEvent.getJobStatus() == JobStatus.FAILED) {
                wrt.write("\"failednodes\": [");
                first = true;
                for (ExecutionVertex vertex : graph.getAllExecutionVertices()) {
                    if (vertex.getExecutionState() != ExecutionState.FAILED) continue;
                    AllocatedSlot slot = vertex.getCurrentAssignedResource();
                    Throwable failureCause = vertex.getFailureCause();
                    if (slot == null && failureCause == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        wrt.write(",");
                    }
                    wrt.write("{");
                    wrt.write("\"node\": \"" + (slot == null ? "(none)" : slot.getInstance().getInstanceConnectionInfo().getFQDNHostname()) + "\",");
                    wrt.write("\"message\": \"" + (failureCause == null ? "" : StringUtils.escapeHtml((String)ExceptionUtils.stringifyException((Throwable)failureCause))) + "\"");
                    wrt.write("}");
                }
                wrt.write("],");
            }
            wrt.write("\"groupvertices\": [");
            first = true;
            for (ExecutionJobVertex groupVertex : graph.getVerticesTopologically()) {
                if (first) {
                    first = false;
                } else {
                    wrt.write(",");
                }
                wrt.write(JsonFactory.toJson(groupVertex));
            }
            wrt.write("],");
            Map accMap = AccumulatorHelper.toResultMap(this.jobmanager.getAccumulators(jobEvent.getJobID()));
            wrt.write("\n\"accumulators\": [");
            int i = 0;
            for (Map.Entry accumulator : accMap.entrySet()) {
                wrt.write("{ \"name\": \"" + (String)accumulator.getKey() + " (" + accumulator.getValue().getClass().getName() + ")\"," + " \"value\": \"" + accumulator.getValue().toString() + "\"}\n");
                if (++i >= accMap.size()) continue;
                wrt.write(",");
            }
            wrt.write("],\n");
            wrt.write("\"groupverticetimes\": {");
            first = true;
            for (ExecutionJobVertex groupVertex : graph.getVerticesTopologically()) {
                if (first) {
                    first = false;
                } else {
                    wrt.write(",");
                }
                long started = Long.MAX_VALUE;
                long ended = 0L;
                for (ExecutionVertex vertex : groupVertex.getTaskVertices()) {
                    long running = vertex.getStateTimestamp(ExecutionState.RUNNING);
                    if (running != 0L && running < started) {
                        started = running;
                    }
                    long finished = vertex.getStateTimestamp(ExecutionState.FINISHED);
                    long canceled = vertex.getStateTimestamp(ExecutionState.CANCELED);
                    long failed = vertex.getStateTimestamp(ExecutionState.FAILED);
                    if (finished != 0L && finished > ended) {
                        ended = finished;
                    }
                    if (canceled != 0L && canceled > ended) {
                        ended = canceled;
                    }
                    if (failed == 0L || failed <= ended) continue;
                    ended = failed;
                }
                wrt.write("\"" + groupVertex.getJobVertexId() + "\": {");
                wrt.write("\"groupvertexid\": \"" + groupVertex.getJobVertexId() + "\",");
                wrt.write("\"groupvertexname\": \"" + groupVertex + "\",");
                wrt.write("\"STARTED\": " + started + ",");
                wrt.write("\"ENDED\": " + ended);
                wrt.write("}");
            }
            wrt.write("}");
            wrt.write("}");
            wrt.write("]");
        }
        catch (EofException eof) {
            LOG.info("Info server for jobmanager: Connection closed by client, EofException");
        }
        catch (IOException ioe) {
            LOG.info("Info server for jobmanager: Connection closed by client, IOException");
        }
    }

    private void writeJsonUpdatesForJob(PrintWriter wrt, JobID jobId) {
        try {
            List<AbstractEvent> events = this.jobmanager.getEvents(jobId);
            wrt.write("{");
            wrt.write("\"jobid\": \"" + jobId + "\",");
            wrt.write("\"timestamp\": \"" + System.currentTimeMillis() + "\",");
            wrt.write("\"recentjobs\": [");
            boolean first = true;
            for (RecentJobEvent rje : this.jobmanager.getRecentJobs()) {
                if (first) {
                    first = false;
                } else {
                    wrt.write(",");
                }
                wrt.write("\"" + rje.getJobID().toString() + "\"");
            }
            wrt.write("],");
            wrt.write("\"vertexevents\": [");
            first = true;
            for (AbstractEvent event : events) {
                if (!(event instanceof ExecutionStateChangeEvent)) continue;
                if (first) {
                    first = false;
                } else {
                    wrt.write(",");
                }
                ExecutionStateChangeEvent vertexevent = (ExecutionStateChangeEvent)event;
                wrt.write("{");
                wrt.write("\"vertexid\": \"" + vertexevent.getExecutionAttemptID() + "\",");
                wrt.write("\"newstate\": \"" + (Object)((Object)vertexevent.getNewExecutionState()) + "\",");
                wrt.write("\"timestamp\": \"" + vertexevent.getTimestamp() + "\"");
                wrt.write("}");
            }
            wrt.write("],");
            wrt.write("\"jobevents\": [");
            first = true;
            for (AbstractEvent event : events) {
                if (!(event instanceof JobEvent)) continue;
                if (first) {
                    first = false;
                } else {
                    wrt.write(",");
                }
                JobEvent jobevent = (JobEvent)event;
                wrt.write("{");
                wrt.write("\"newstate\": \"" + (Object)((Object)jobevent.getCurrentJobStatus()) + "\",");
                wrt.write("\"timestamp\": \"" + jobevent.getTimestamp() + "\"");
                wrt.write("}");
            }
            wrt.write("]");
            wrt.write("}");
        }
        catch (EofException eof) {
            LOG.info("Info server for jobmanager: Connection closed by client, EofException");
        }
        catch (IOException ioe) {
            LOG.info("Info server for jobmanager: Connection closed by client, IOException");
        }
    }

    private void writeJsonForArchivedJobGroupvertex(PrintWriter wrt, RecentJobEvent jobEvent, JobVertexID vertexId) {
        block7: {
            try {
                ExecutionGraph graph = this.jobmanager.getRecentExecutionGraph(jobEvent.getJobID());
                ExecutionJobVertex jobVertex = graph.getJobVertex(vertexId);
                wrt.write("{\"groupvertex\": " + JsonFactory.toJson(jobVertex) + ",");
                wrt.write("\"verticetimes\": {");
                boolean first = true;
                for (ExecutionJobVertex groupVertex : graph.getAllVertices().values()) {
                    for (ExecutionVertex vertex : groupVertex.getTaskVertices()) {
                        Execution exec = vertex.getCurrentExecutionAttempt();
                        if (first) {
                            first = false;
                        } else {
                            wrt.write(",");
                        }
                        wrt.write("\"" + exec.getAttemptId() + "\": {");
                        wrt.write("\"vertexid\": \"" + exec.getAttemptId() + "\",");
                        wrt.write("\"vertexname\": \"" + vertex + "\",");
                        wrt.write("\"CREATED\": " + vertex.getStateTimestamp(ExecutionState.CREATED) + ",");
                        wrt.write("\"SCHEDULED\": " + vertex.getStateTimestamp(ExecutionState.SCHEDULED) + ",");
                        wrt.write("\"DEPLOYING\": " + vertex.getStateTimestamp(ExecutionState.DEPLOYING) + ",");
                        wrt.write("\"RUNNING\": " + vertex.getStateTimestamp(ExecutionState.RUNNING) + ",");
                        wrt.write("\"FINISHED\": " + vertex.getStateTimestamp(ExecutionState.FINISHED) + ",");
                        wrt.write("\"CANCELING\": " + vertex.getStateTimestamp(ExecutionState.CANCELING) + ",");
                        wrt.write("\"CANCELED\": " + vertex.getStateTimestamp(ExecutionState.CANCELED) + ",");
                        wrt.write("\"FAILED\": " + vertex.getStateTimestamp(ExecutionState.FAILED) + "");
                        wrt.write("}");
                    }
                }
                wrt.write("}}");
            }
            catch (IOException ioe) {
                String message = "Info server for jobmanager: Connection closed by client - " + ioe.getClass().getSimpleName();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(message, (Throwable)ioe);
                }
                if (!LOG.isInfoEnabled()) break block7;
                LOG.info(message);
            }
        }
    }

    private void writeJsonForVersion(PrintWriter wrt) {
        wrt.write("{");
        wrt.write("\"version\": \"" + EnvironmentInformation.getVersion() + "\",");
        wrt.write("\"revision\": \"" + EnvironmentInformation.getRevisionInformation().commitId + "\"");
        wrt.write("}");
    }
}

