/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.flink.api.common.functions.FlatCombineFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.ChannelWriterOutputView;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memorymanager.MemoryAllocationException;
import org.apache.flink.runtime.memorymanager.MemoryManager;
import org.apache.flink.runtime.operators.sort.ExceptionHandler;
import org.apache.flink.runtime.operators.sort.InMemorySorter;
import org.apache.flink.runtime.operators.sort.MergeIterator;
import org.apache.flink.runtime.operators.sort.UnilateralSortMerger;
import org.apache.flink.runtime.util.KeyGroupedIterator;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.TraversableOnceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombiningUnilateralSortMerger<E>
extends UnilateralSortMerger<E> {
    private static final Logger LOG = LoggerFactory.getLogger(CombiningUnilateralSortMerger.class);
    private final FlatCombineFunction<E> combineStub;
    private Configuration udfConfig;

    public CombiningUnilateralSortMerger(FlatCombineFunction<E> combineStub, MemoryManager memoryManager, IOManager ioManager, MutableObjectIterator<E> input, AbstractInvokable parentTask, TypeSerializerFactory<E> serializerFactory, TypeComparator<E> comparator, double memoryFraction, int maxNumFileHandles, float startSpillingFraction) throws IOException, MemoryAllocationException {
        this(combineStub, memoryManager, ioManager, input, parentTask, serializerFactory, comparator, memoryFraction, -1, maxNumFileHandles, startSpillingFraction);
    }

    public CombiningUnilateralSortMerger(FlatCombineFunction<E> combineStub, MemoryManager memoryManager, IOManager ioManager, MutableObjectIterator<E> input, AbstractInvokable parentTask, TypeSerializerFactory<E> serializerFactory, TypeComparator<E> comparator, double memoryFraction, int numSortBuffers, int maxNumFileHandles, float startSpillingFraction) throws IOException, MemoryAllocationException {
        super(memoryManager, ioManager, input, parentTask, serializerFactory, comparator, memoryFraction, numSortBuffers, maxNumFileHandles, startSpillingFraction, false);
        this.combineStub = combineStub;
    }

    public void setUdfConfiguration(Configuration config) {
        this.udfConfig = config;
    }

    @Override
    protected UnilateralSortMerger.ThreadBase<E> getSpillingThread(ExceptionHandler<IOException> exceptionHandler, UnilateralSortMerger.CircularQueues<E> queues, AbstractInvokable parentTask, MemoryManager memoryManager, IOManager ioManager, TypeSerializerFactory<E> serializerFactory, TypeComparator<E> comparator, List<MemorySegment> sortReadMemory, List<MemorySegment> writeMemory, int maxFileHandles) {
        return new CombiningSpillingThread(exceptionHandler, queues, parentTask, memoryManager, ioManager, serializerFactory.getSerializer(), comparator, sortReadMemory, writeMemory, maxFileHandles);
    }

    static /* synthetic */ Configuration access$200(CombiningUnilateralSortMerger x0) {
        return x0.udfConfig;
    }

    private static final class WriterCollector<E>
    implements Collector<E> {
        private final ChannelWriterOutputView output;
        private final TypeSerializer<E> serializer;

        private WriterCollector(ChannelWriterOutputView output, TypeSerializer<E> serializer) {
            this.output = output;
            this.serializer = serializer;
        }

        public void collect(E record) {
            try {
                this.serializer.serialize(record, (DataOutputView)this.output);
            }
            catch (IOException ioex) {
                throw new RuntimeException("An error occurred forwarding the record to the writer.", ioex);
            }
        }

        public void close() {
        }
    }

    private static final class CombineValueIterator<E>
    implements Iterator<E>,
    Iterable<E> {
        private final InMemorySorter<E> buffer;
        private E record;
        private int last;
        private int position;
        private boolean iteratorAvailable;

        public CombineValueIterator(InMemorySorter<E> buffer, E instance) {
            this.buffer = buffer;
            this.record = instance;
        }

        public void set(int first, int last) {
            this.last = last;
            this.position = first;
            this.iteratorAvailable = true;
        }

        @Override
        public boolean hasNext() {
            return this.position <= this.last;
        }

        @Override
        public E next() {
            if (this.position <= this.last) {
                try {
                    this.record = this.buffer.getRecord(this.record, this.position);
                    ++this.position;
                    return this.record;
                }
                catch (IOException ioex) {
                    LOG.error("Error retrieving a value from a buffer.", (Throwable)ioex);
                    throw new RuntimeException("Could not load the next value: " + ioex.getMessage(), ioex);
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            if (this.iteratorAvailable) {
                this.iteratorAvailable = false;
                return this;
            }
            throw new TraversableOnceException();
        }
    }

    protected class CombiningSpillingThread
    extends UnilateralSortMerger.SpillingThread {
        private final TypeComparator<E> comparator2;

        public CombiningSpillingThread(ExceptionHandler<IOException> exceptionHandler, UnilateralSortMerger.CircularQueues<E> queues, AbstractInvokable parentTask, MemoryManager memManager, IOManager ioManager, TypeSerializer<E> serializer, TypeComparator<E> comparator, List<MemorySegment> sortReadMemory, List<MemorySegment> writeMemory, int maxNumFileHandles) {
            super(CombiningUnilateralSortMerger.this, exceptionHandler, queues, parentTask, memManager, ioManager, serializer, comparator, sortReadMemory, writeMemory, maxNumFileHandles);
            this.comparator2 = comparator.duplicate();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void go() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
             *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        protected UnilateralSortMerger.ChannelWithBlockCount mergeChannels(List<UnilateralSortMerger.ChannelWithBlockCount> channelIDs, List<List<MemorySegment>> readBuffers, List<MemorySegment> writeBuffers) throws IOException {
            ArrayList<FileIOChannel> channelAccesses = new ArrayList<FileIOChannel>(channelIDs.size());
            MergeIterator mergeIterator = this.getMergingIterator(channelIDs, readBuffers, channelAccesses);
            KeyGroupedIterator groupedIter = new KeyGroupedIterator(mergeIterator, this.serializer, this.comparator2);
            FileIOChannel.ID mergedChannelID = this.ioManager.createChannel();
            this.registerChannelToBeRemovedAtShudown(mergedChannelID);
            BlockChannelWriter writer = this.ioManager.createBlockChannelWriter(mergedChannelID);
            this.registerOpenChannelToBeRemovedAtShudown(writer);
            ChannelWriterOutputView output = new ChannelWriterOutputView(writer, writeBuffers, this.memManager.getPageSize());
            WriterCollector collector = new WriterCollector(output, this.serializer);
            FlatCombineFunction combineStub = CombiningUnilateralSortMerger.this.combineStub;
            try {
                while (groupedIter.nextKey()) {
                    combineStub.combine((Iterable)groupedIter.getValues(), collector);
                }
            }
            catch (Exception e) {
                throw new IOException("An error occurred in the combiner user code.");
            }
            output.close();
            int numBlocksWritten = output.getBlockCount();
            this.unregisterOpenChannelToBeRemovedAtShudown(writer);
            for (int i = 0; i < channelAccesses.size(); ++i) {
                FileIOChannel access = (FileIOChannel)channelAccesses.get(i);
                access.closeAndDelete();
                this.unregisterOpenChannelToBeRemovedAtShudown(access);
            }
            return new UnilateralSortMerger.ChannelWithBlockCount(mergedChannelID, numBlocksWritten);
        }
    }
}

