/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.blob.BlobUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlobCache
implements BlobService {
    private static final Logger LOG = LoggerFactory.getLogger(BlobCache.class);
    private final InetSocketAddress serverAddress;
    private final File storageDir;

    public BlobCache(InetSocketAddress serverAddress) {
        this.serverAddress = serverAddress;
        this.storageDir = BlobUtils.initStorageDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(BlobKey requiredBlob) throws IOException {
        if (requiredBlob == null) {
            throw new IllegalArgumentException("Required BLOB cannot be null.");
        }
        BlobClient bc = null;
        byte[] buf = null;
        URL url = null;
        try {
            File localJarFile = BlobUtils.getStorageLocation(this.storageDir, requiredBlob);
            if (!localJarFile.exists()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Trying to download " + requiredBlob + " from " + this.serverAddress);
                }
                if (bc == null) {
                    if (this.serverAddress == null) {
                        throw new IllegalArgumentException("Argument serverAddress is null: Cannot download libraries from BLOB server");
                    }
                    bc = new BlobClient(this.serverAddress);
                    buf = new byte[4096];
                }
                InputStream is = null;
                OutputStream os = null;
                try {
                    int read;
                    is = bc.get(requiredBlob);
                    os = new FileOutputStream(localJarFile);
                    while ((read = is.read(buf)) >= 0) {
                        os.write(buf, 0, read);
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
            }
            url = localJarFile.toURI().toURL();
        }
        finally {
            if (bc != null) {
                bc.close();
            }
        }
        return url;
    }

    @Override
    public void delete(BlobKey key) throws IOException {
        File localFile = BlobUtils.getStorageLocation(this.storageDir, key);
        if (localFile.exists()) {
            localFile.delete();
        }
    }

    @Override
    public int getPort() {
        return this.serverAddress.getPort();
    }

    @Override
    public void shutdown() throws IOException {
        FileUtils.deleteDirectory((File)this.storageDir);
    }
}

