/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import org.apache.flink.runtime.instance.AllocatedSlot;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.instance.InstanceDiedException;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.ipc.RPC;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobmanager.scheduler.SlotAvailabilityListener;
import org.apache.flink.runtime.net.NetUtils;
import org.apache.flink.runtime.protocols.TaskOperationProtocol;
import org.eclipse.jetty.util.log.Log;

public class Instance {
    private final Object instanceLock = new Object();
    private final InstanceConnectionInfo instanceConnectionInfo;
    private final HardwareDescription resources;
    private final InstanceID instanceId;
    private final int numberOfSlots;
    private final Queue<Integer> availableSlots;
    private final Set<AllocatedSlot> allocatedSlots = new HashSet<AllocatedSlot>();
    private SlotAvailabilityListener slotAvailabilityListener;
    private volatile TaskOperationProtocol taskManager;
    private volatile long lastReceivedHeartBeat = System.currentTimeMillis();
    private volatile boolean isDead;

    public Instance(InstanceConnectionInfo instanceConnectionInfo, InstanceID id, HardwareDescription resources, int numberOfSlots) {
        this.instanceConnectionInfo = instanceConnectionInfo;
        this.instanceId = id;
        this.resources = resources;
        this.numberOfSlots = numberOfSlots;
        this.availableSlots = new ArrayDeque<Integer>(numberOfSlots);
        for (int i = 0; i < numberOfSlots; ++i) {
            this.availableSlots.add(i);
        }
    }

    public InstanceID getId() {
        return this.instanceId;
    }

    public HardwareDescription getResources() {
        return this.resources;
    }

    public int getTotalNumberOfSlots() {
        return this.numberOfSlots;
    }

    public InstanceConnectionInfo getInstanceConnectionInfo() {
        return this.instanceConnectionInfo;
    }

    public boolean isAlive() {
        return !this.isDead;
    }

    public void stopInstance() {
        block2: {
            try {
                final TaskOperationProtocol tmProxy = this.getTaskManagerProxy();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                tmProxy.killTaskManager();
                            }
                            catch (IOException e) {
                                if (!Log.isDebugEnabled()) break block2;
                                Log.debug((String)"Error while stopping TaskManager", (Object)e);
                            }
                        }
                    }
                };
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.start();
            }
            catch (Exception e) {
                if (!Log.isDebugEnabled()) break block2;
                Log.debug((String)"Error while stopping TaskManager", (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDead() {
        if (this.isDead) {
            return;
        }
        this.isDead = true;
        Object object = this.instanceLock;
        synchronized (object) {
            this.slotAvailabilityListener = null;
            for (AllocatedSlot slot : this.allocatedSlots) {
                slot.releaseSlot();
            }
            this.allocatedSlots.clear();
            this.availableSlots.clear();
        }
        this.destroyTaskManagerProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskOperationProtocol getTaskManagerProxy() throws IOException {
        if (this.isDead) {
            throw new IOException("Instance has died");
        }
        TaskOperationProtocol tm = this.taskManager;
        if (tm == null) {
            Instance instance = this;
            synchronized (instance) {
                if (this.taskManager == null) {
                    this.taskManager = RPC.getProxy(TaskOperationProtocol.class, new InetSocketAddress(this.getInstanceConnectionInfo().address(), this.getInstanceConnectionInfo().ipcPort()), NetUtils.getSocketFactory());
                }
                tm = this.taskManager;
            }
        }
        return tm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyTaskManagerProxy() {
        Instance instance = this;
        synchronized (instance) {
            if (this.taskManager != null) {
                try {
                    RPC.stopProxy(this.taskManager);
                }
                catch (Throwable t) {
                    Log.debug((String)"Error shutting down RPC proxy.", (Object)t);
                }
            }
        }
    }

    public long getLastHeartBeat() {
        return this.lastReceivedHeartBeat;
    }

    public void reportHeartBeat() {
        this.lastReceivedHeartBeat = System.currentTimeMillis();
    }

    public boolean isStillAlive(long now, long cleanUpInterval) {
        return this.lastReceivedHeartBeat + cleanUpInterval > now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllocatedSlot allocateSlot(JobID jobID) throws InstanceDiedException {
        if (jobID == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.instanceLock;
        synchronized (object) {
            if (this.isDead) {
                throw new InstanceDiedException(this);
            }
            Integer nextSlot = this.availableSlots.poll();
            if (nextSlot == null) {
                return null;
            }
            AllocatedSlot slot = new AllocatedSlot(jobID, this, nextSlot);
            this.allocatedSlots.add(slot);
            return slot;
        }
    }

    public boolean returnAllocatedSlot(AllocatedSlot slot) {
        if (slot == null || slot.getInstance() != this) {
            throw new IllegalArgumentException("Slot is null or belongs to the wrong instance.");
        }
        if (slot.isAlive()) {
            throw new IllegalArgumentException("Slot is still alive");
        }
        if (slot.markReleased()) {
            Object object = this.instanceLock;
            synchronized (object) {
                if (this.isDead) {
                    return false;
                }
                if (this.allocatedSlots.remove(slot)) {
                    this.availableSlots.add(slot.getSlotNumber());
                    if (this.slotAvailabilityListener != null) {
                        this.slotAvailabilityListener.newSlotAvailable(this);
                    }
                    return true;
                }
                throw new IllegalArgumentException("Slot was not allocated from the instance.");
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAndReleaseAllSlots() {
        Object object = this.instanceLock;
        synchronized (object) {
            ArrayList<AllocatedSlot> copy = new ArrayList<AllocatedSlot>(this.allocatedSlots);
            for (AllocatedSlot slot : copy) {
                slot.releaseSlot();
            }
            this.allocatedSlots.clear();
        }
    }

    public int getNumberOfAvailableSlots() {
        return this.availableSlots.size();
    }

    public int getNumberOfAllocatedSlots() {
        return this.allocatedSlots.size();
    }

    public boolean hasResourcesAvailable() {
        return !this.isDead && this.getNumberOfAvailableSlots() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSlotAvailabilityListener(SlotAvailabilityListener slotAvailabilityListener) {
        Object object = this.instanceLock;
        synchronized (object) {
            if (this.slotAvailabilityListener != null) {
                throw new IllegalStateException("Instance has already a slot listener.");
            }
            this.slotAvailabilityListener = slotAvailabilityListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSlotListener() {
        Object object = this.instanceLock;
        synchronized (object) {
            this.slotAvailabilityListener = null;
        }
    }

    public String toString() {
        return this.instanceId + " @" + this.instanceConnectionInfo + ' ' + this.numberOfSlots + " slots";
    }
}

