/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriterWithCallback;
import org.apache.flink.runtime.io.disk.iomanager.BulkBlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.RequestDoneCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IOManager {
    protected static final Logger LOG = LoggerFactory.getLogger(IOManager.class);
    private final String[] paths;
    private final Random random;
    private volatile int nextPath;

    protected IOManager(String[] paths) {
        this.paths = paths;
        this.random = new Random();
        this.nextPath = 0;
    }

    public abstract void shutdown();

    public abstract boolean isProperlyShutDown();

    public FileIOChannel.ID createChannel() {
        int num = this.getNextPathNum();
        return new FileIOChannel.ID(this.paths[num], num, this.random);
    }

    public FileIOChannel.Enumerator createChannelEnumerator() {
        return new FileIOChannel.Enumerator(this.paths, this.random);
    }

    public BlockChannelWriter createBlockChannelWriter(FileIOChannel.ID channelID) throws IOException {
        return this.createBlockChannelWriter(channelID, new LinkedBlockingQueue<MemorySegment>());
    }

    public abstract BlockChannelWriter createBlockChannelWriter(FileIOChannel.ID var1, LinkedBlockingQueue<MemorySegment> var2) throws IOException;

    public abstract BlockChannelWriterWithCallback createBlockChannelWriter(FileIOChannel.ID var1, RequestDoneCallback var2) throws IOException;

    public BlockChannelReader createBlockChannelReader(FileIOChannel.ID channelID) throws IOException {
        return this.createBlockChannelReader(channelID, new LinkedBlockingQueue<MemorySegment>());
    }

    public abstract BlockChannelReader createBlockChannelReader(FileIOChannel.ID var1, LinkedBlockingQueue<MemorySegment> var2) throws IOException;

    public abstract BulkBlockChannelReader createBulkBlockChannelReader(FileIOChannel.ID var1, List<MemorySegment> var2, int var3) throws IOException;

    protected int getNextPathNum() {
        int next = this.nextPath;
        int newNext = next + 1;
        this.nextPath = newNext >= this.paths.length ? 0 : newNext;
        return next;
    }
}

