/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api;

import java.io.IOException;
import org.apache.flink.runtime.event.task.AbstractEvent;
import org.apache.flink.runtime.event.task.AbstractTaskEvent;
import org.apache.flink.runtime.event.task.EventListener;
import org.apache.flink.runtime.io.network.Buffer;
import org.apache.flink.runtime.io.network.channels.EndOfSuperstepEvent;
import org.apache.flink.runtime.io.network.gates.OutputGate;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;

public class BufferWriter {
    protected final OutputGate outputGate;

    public BufferWriter(AbstractInvokable invokable) {
        this.outputGate = invokable.getEnvironment().createAndRegisterOutputGate();
    }

    public void sendBuffer(Buffer buffer, int targetChannel) throws IOException, InterruptedException {
        this.outputGate.sendBuffer(buffer, targetChannel);
    }

    public void sendEvent(AbstractEvent event, int targetChannel) throws IOException, InterruptedException {
        this.outputGate.sendEvent(event, targetChannel);
    }

    public void sendBufferAndEvent(Buffer buffer, AbstractEvent event, int targetChannel) throws IOException, InterruptedException {
        this.outputGate.sendBufferAndEvent(buffer, event, targetChannel);
    }

    public void broadcastBuffer(Buffer buffer) throws IOException, InterruptedException {
        this.outputGate.broadcastBuffer(buffer);
    }

    public void broadcastEvent(AbstractEvent event) throws IOException, InterruptedException {
        this.outputGate.broadcastEvent(event);
    }

    public void subscribeToEvent(EventListener eventListener, Class<? extends AbstractTaskEvent> eventType) {
        this.outputGate.subscribeToEvent(eventListener, eventType);
    }

    public void unsubscribeFromEvent(EventListener eventListener, Class<? extends AbstractTaskEvent> eventType) {
        this.outputGate.unsubscribeFromEvent(eventListener, eventType);
    }

    public void sendEndOfSuperstep() throws IOException, InterruptedException {
        this.outputGate.broadcastEvent(EndOfSuperstepEvent.INSTANCE);
    }
}

