/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api;

import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.AbstractUnionRecordReader;
import org.apache.flink.runtime.io.network.api.MutableRecordReader;
import org.apache.flink.runtime.io.network.api.Reader;

public final class UnionRecordReader<T extends IOReadableWritable>
extends AbstractUnionRecordReader<T>
implements Reader<T> {
    private final Class<T> recordType;
    private T lookahead;

    public UnionRecordReader(MutableRecordReader<T>[] recordReaders, Class<T> recordType) {
        super(recordReaders);
        this.recordType = recordType;
    }

    @Override
    public boolean hasNext() throws IOException, InterruptedException {
        if (this.lookahead != null) {
            return true;
        }
        T record = this.instantiateRecordType();
        if (this.getNextRecord(record)) {
            this.lookahead = record;
            return true;
        }
        return false;
    }

    @Override
    public T next() throws IOException, InterruptedException {
        if (this.hasNext()) {
            T tmp = this.lookahead;
            this.lookahead = null;
            return tmp;
        }
        return null;
    }

    private T instantiateRecordType() {
        try {
            return (T)((IOReadableWritable)this.recordType.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot instantiate class '" + this.recordType.getName() + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot instantiate class '" + this.recordType.getName() + "'.", e);
        }
    }
}

