/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.execution.ExecutionListener;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.execution.RuntimeEnvironment;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.memorymanager.MemoryManager;
import org.apache.flink.runtime.profiling.TaskManagerProfiler;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Task {
    private static final AtomicReferenceFieldUpdater<Task, ExecutionState> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Task.class, ExecutionState.class, "executionState");
    private static final Logger LOG = LoggerFactory.getLogger(Task.class);
    private final JobID jobId;
    private final JobVertexID vertexId;
    private final int subtaskIndex;
    private final int numberOfSubtasks;
    private final ExecutionAttemptID executionId;
    private final String taskName;
    private final TaskManager taskManager;
    private final List<ExecutionListener> executionListeners = new CopyOnWriteArrayList<ExecutionListener>();
    private volatile RuntimeEnvironment environment;
    private volatile ExecutionState executionState = ExecutionState.DEPLOYING;

    public Task(JobID jobId, JobVertexID vertexId, int taskIndex, int parallelism, ExecutionAttemptID executionId, String taskName, TaskManager taskManager) {
        this.jobId = jobId;
        this.vertexId = vertexId;
        this.subtaskIndex = taskIndex;
        this.numberOfSubtasks = parallelism;
        this.executionId = executionId;
        this.taskName = taskName;
        this.taskManager = taskManager;
    }

    public JobID getJobID() {
        return this.jobId;
    }

    public JobVertexID getVertexID() {
        return this.vertexId;
    }

    public int getSubtaskIndex() {
        return this.subtaskIndex;
    }

    public int getNumberOfSubtasks() {
        return this.numberOfSubtasks;
    }

    public ExecutionAttemptID getExecutionId() {
        return this.executionId;
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    public void setEnvironment(RuntimeEnvironment environment) {
        this.environment = environment;
    }

    public RuntimeEnvironment getEnvironment() {
        return this.environment;
    }

    public boolean isCanceledOrFailed() {
        return this.executionState == ExecutionState.CANCELING || this.executionState == ExecutionState.CANCELED || this.executionState == ExecutionState.FAILED;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskNameWithSubtasks() {
        return this.taskName + " (" + (this.subtaskIndex + 1) + "/" + this.numberOfSubtasks + ")";
    }

    public boolean markAsFinished() {
        if (STATE_UPDATER.compareAndSet(this, ExecutionState.RUNNING, ExecutionState.FINISHED)) {
            this.notifyObservers(ExecutionState.FINISHED, null);
            this.taskManager.notifyExecutionStateChange(this.jobId, this.executionId, ExecutionState.FINISHED, null);
            return true;
        }
        return false;
    }

    public void markFailed(Throwable error) {
        ExecutionState current;
        do {
            if ((current = this.executionState) != ExecutionState.CANCELED) continue;
            return;
        } while (!STATE_UPDATER.compareAndSet(this, current, ExecutionState.FAILED));
        this.notifyObservers(ExecutionState.FAILED, ExceptionUtils.stringifyException((Throwable)error));
        this.taskManager.notifyExecutionStateChange(this.jobId, this.executionId, ExecutionState.FAILED, error);
    }

    public void cancelExecution() {
        ExecutionState current;
        block5: {
            while (true) {
                if ((current = this.executionState) == ExecutionState.FINISHED || current == ExecutionState.CANCELED || current == ExecutionState.CANCELING || current == ExecutionState.FAILED) {
                    return;
                }
                if (current == ExecutionState.DEPLOYING) {
                    if (!STATE_UPDATER.compareAndSet(this, current, ExecutionState.CANCELED)) continue;
                    this.notifyObservers(ExecutionState.CANCELED, null);
                    this.taskManager.notifyExecutionStateChange(this.jobId, this.executionId, ExecutionState.CANCELED, null);
                    return;
                }
                if (current != ExecutionState.RUNNING) break block5;
                if (STATE_UPDATER.compareAndSet(this, current, ExecutionState.CANCELING)) break;
            }
            this.notifyObservers(ExecutionState.CANCELING, null);
            try {
                this.environment.cancelExecution();
            }
            catch (Throwable e) {
                LOG.error("Error while cancelling the task.", e);
            }
            return;
        }
        throw new RuntimeException("unexpected state for cancelling: " + (Object)((Object)current));
    }

    /*
     * Unable to fully structure code
     */
    public void failExternally(Throwable cause) {
        block4: {
            do lbl-1000:
            // 3 sources

            {
                block5: {
                    if ((current = this.executionState) == ExecutionState.FINISHED || current == ExecutionState.CANCELED || current == ExecutionState.CANCELING || current == ExecutionState.FAILED) {
                        return;
                    }
                    if (current != ExecutionState.DEPLOYING) break block5;
                    if (!Task.STATE_UPDATER.compareAndSet(this, current, ExecutionState.FAILED)) ** GOTO lbl-1000
                    this.notifyObservers(ExecutionState.FAILED, null);
                    this.taskManager.notifyExecutionStateChange(this.jobId, this.executionId, ExecutionState.FAILED, cause);
                    return;
                }
                if (current != ExecutionState.RUNNING) break block4;
            } while (!Task.STATE_UPDATER.compareAndSet(this, current, ExecutionState.FAILED));
            try {
                this.environment.cancelExecution();
            }
            catch (Throwable e) {
                Task.LOG.error("Error while cancelling the task.", e);
            }
            this.notifyObservers(ExecutionState.FAILED, null);
            this.taskManager.notifyExecutionStateChange(this.jobId, this.executionId, ExecutionState.FAILED, cause);
            return;
        }
        throw new RuntimeException("unexpected state for cancelling: " + (Object)current);
    }

    public void cancelingDone() {
        ExecutionState current;
        do {
            if ((current = this.executionState) == ExecutionState.CANCELED || current == ExecutionState.FAILED) {
                return;
            }
            if (current == ExecutionState.RUNNING || current == ExecutionState.CANCELING) continue;
            LOG.error(String.format("Unexpected state transition in Task: %s -> %s", new Object[]{current, ExecutionState.CANCELED}));
        } while (!STATE_UPDATER.compareAndSet(this, current, ExecutionState.CANCELED));
        this.notifyObservers(ExecutionState.CANCELED, null);
        this.taskManager.notifyExecutionStateChange(this.jobId, this.executionId, ExecutionState.CANCELED, null);
    }

    public boolean startExecution() {
        if (STATE_UPDATER.compareAndSet(this, ExecutionState.DEPLOYING, ExecutionState.RUNNING)) {
            Thread thread = this.environment.getExecutingThread();
            thread.start();
            return true;
        }
        return false;
    }

    public void unregisterMemoryManager(MemoryManager memoryManager) {
        RuntimeEnvironment env = this.environment;
        if (memoryManager != null && env != null) {
            memoryManager.releaseAll(env.getInvokable());
        }
    }

    public void registerProfiler(TaskManagerProfiler taskManagerProfiler, Configuration jobConfiguration) {
        taskManagerProfiler.registerExecutionListener(this, jobConfiguration);
    }

    public void unregisterProfiler(TaskManagerProfiler taskManagerProfiler) {
        if (taskManagerProfiler != null) {
            taskManagerProfiler.unregisterExecutionListener(this.executionId);
        }
    }

    public void registerExecutionListener(ExecutionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.executionListeners.add(listener);
    }

    public void unregisterExecutionListener(ExecutionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.executionListeners.remove(listener);
    }

    private void notifyObservers(ExecutionState newState, String message) {
        if (LOG.isInfoEnabled()) {
            LOG.info(this.getTaskNameWithSubtasks() + " switched to " + (Object)((Object)newState) + (message == null ? "" : " : " + message));
        }
        for (ExecutionListener listener : this.executionListeners) {
            try {
                listener.executionStateChanged(this.jobId, this.vertexId, this.subtaskIndex, this.executionId, newState, message);
            }
            catch (Throwable t) {
                LOG.error("Error while calling execution listener.", t);
            }
        }
    }

    public String toString() {
        return this.getTaskNameWithSubtasks() + " [" + (Object)((Object)this.executionState) + ']';
    }
}

