/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.S3Object;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.util.StringUtils;

public class S3DataInputStream
extends FSDataInputStream {
    private final InputStream inputStream;
    private long position;
    private long marked;

    S3DataInputStream(AmazonS3Client s3Client, String bucket, String object) throws IOException {
        S3Object s3o = null;
        try {
            s3o = s3Client.getObject(bucket, object);
        }
        catch (AmazonServiceException e) {
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
        this.inputStream = s3o.getObjectContent();
        this.position = 0L;
        this.marked = 0L;
    }

    public int available() throws IOException {
        return this.inputStream.available();
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public void mark(int readlimit) {
        this.inputStream.mark(readlimit);
        this.marked = readlimit;
    }

    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    public int read() throws IOException {
        int read = this.inputStream.read();
        if (read != -1) {
            ++this.position;
        }
        return read;
    }

    public int read(byte[] b) throws IOException {
        int read = this.inputStream.read(b);
        if (read > 0) {
            this.position += (long)read;
        }
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.inputStream.read(b, off, len);
        if (read > 0) {
            this.position += (long)read;
        }
        return read;
    }

    public void reset() throws IOException {
        this.inputStream.reset();
        this.position = this.marked;
    }

    public void seek(long desired) throws IOException {
        this.skip(desired);
    }

    public long skip(long n) throws IOException {
        long skipped = this.inputStream.skip(n);
        if (skipped > 0L) {
            this.position += skipped;
        }
        return skipped;
    }
}

