/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.event.task.AbstractEvent;
import org.apache.flink.runtime.io.network.Envelope;
import org.apache.flink.runtime.io.network.RemoteReceiver;
import org.apache.flink.runtime.io.network.channels.ChannelID;

public final class SenderHintEvent
extends AbstractEvent {
    private static final int SENDER_HINT_SEQUENCE_NUMBER = 0;
    private final ChannelID source;
    private final RemoteReceiver remoteReceiver;

    SenderHintEvent(ChannelID source, RemoteReceiver remoteReceiver) {
        if (source == null) {
            throw new IllegalArgumentException("Argument source must not be null");
        }
        if (remoteReceiver == null) {
            throw new IllegalArgumentException("Argument remoteReceiver must not be null");
        }
        this.source = source;
        this.remoteReceiver = remoteReceiver;
    }

    public SenderHintEvent() {
        this.source = new ChannelID();
        this.remoteReceiver = new RemoteReceiver();
    }

    public ChannelID getSource() {
        return this.source;
    }

    public RemoteReceiver getRemoteReceiver() {
        return this.remoteReceiver;
    }

    public void write(DataOutputView out) throws IOException {
        this.source.write(out);
        this.remoteReceiver.write(out);
    }

    public void read(DataInputView in) throws IOException {
        this.source.read(in);
        this.remoteReceiver.read(in);
    }

    public static Envelope createEnvelopeWithEvent(Envelope originalEnvelope, ChannelID source, RemoteReceiver remoteReceiver) {
        Envelope envelope = new Envelope(0, originalEnvelope.getJobID(), originalEnvelope.getSource());
        SenderHintEvent senderEvent = new SenderHintEvent(source, remoteReceiver);
        envelope.serializeEventList(Arrays.asList(senderEvent));
        return envelope;
    }

    static boolean isSenderHintEvent(Envelope envelope) {
        if (envelope.getSequenceNumber() != 0) {
            return false;
        }
        if (envelope.getBuffer() != null) {
            return false;
        }
        List<? extends AbstractEvent> events = envelope.deserializeEvents();
        if (events.size() != 1) {
            return false;
        }
        return events.get(0) instanceof SenderHintEvent;
    }
}

