/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.runtime.AbstractID;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.instance.Slot;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroupAssignment;

public class SharedSlot
extends Slot {
    private final SlotSharingGroupAssignment assignmentGroup;
    private final Set<Slot> subSlots;

    public SharedSlot(JobID jobID, Instance instance, int slotNumber, SlotSharingGroupAssignment assignmentGroup, SharedSlot parent, AbstractID groupID) {
        super(jobID, instance, slotNumber, parent, groupID);
        this.assignmentGroup = assignmentGroup;
        this.subSlots = new HashSet<Slot>();
    }

    public Set<Slot> getSubSlots() {
        return this.subSlots;
    }

    public int freeSubSlot(Slot slot) {
        if (!this.subSlots.remove(slot)) {
            throw new IllegalArgumentException("Wrong shared slot for sub slot.");
        }
        return this.subSlots.size();
    }

    @Override
    public int getNumberLeaves() {
        int result = 0;
        for (Slot slot : this.subSlots) {
            result += slot.getNumberLeaves();
        }
        return result;
    }

    @Override
    public void cancel() {
        if (this.markCancelled()) {
            this.assignmentGroup.releaseSharedSlot(this);
        }
    }

    @Override
    public void releaseSlot() {
        this.assignmentGroup.releaseSharedSlot(this);
    }

    public SimpleSlot allocateSubSlot(AbstractID jID) {
        if (this.isDead()) {
            return null;
        }
        SimpleSlot slot = new SimpleSlot(this.jobID, this.instance, this.subSlots.size(), this, jID);
        this.subSlots.add(slot);
        return slot;
    }

    public SharedSlot allocateSharedSlot(AbstractID jID) {
        if (this.isDead()) {
            return null;
        }
        SharedSlot slot = new SharedSlot(this.jobID, this.instance, this.subSlots.size(), this.assignmentGroup, this, jID);
        this.subSlots.add(slot);
        return slot;
    }

    public void disposeChild(SimpleSlot slot) {
        this.assignmentGroup.releaseSimpleSlot(slot);
    }

    @Override
    public String toString() {
        return "Shared " + super.toString();
    }
}

