/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.apache.flink.util.StringUtils;

public interface FileIOChannel {
    public ID getChannelID();

    public boolean isClosed();

    public void close() throws IOException;

    public void deleteChannel();

    public void closeAndDelete() throws IOException;

    public static final class Enumerator {
        private static final String FORMAT = "%s%s%s.%06d.channel";
        private final String[] paths;
        private final String namePrefix;
        private int counter;

        protected Enumerator(String[] basePaths, Random random) {
            this.paths = basePaths;
            this.namePrefix = ID.randomString(random);
            this.counter = 0;
        }

        public ID next() {
            int threadNum = this.counter % this.paths.length;
            return new ID(String.format(FORMAT, this.paths[threadNum], File.separator, this.namePrefix, this.counter++), threadNum);
        }
    }

    public static class ID {
        private static final int RANDOM_BYTES_LENGTH = 16;
        private final String path;
        private final int threadNum;

        protected ID(String path, int threadNum) {
            this.path = path;
            this.threadNum = threadNum;
        }

        protected ID(String basePath, int threadNum, Random random) {
            this.path = basePath + File.separator + ID.randomString(random) + ".channel";
            this.threadNum = threadNum;
        }

        public String getPath() {
            return this.path;
        }

        int getThreadNum() {
            return this.threadNum;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ID) {
                ID other = (ID)obj;
                return this.path.equals(other.path) && this.threadNum == other.threadNum;
            }
            return false;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public String toString() {
            return this.path;
        }

        private static final String randomString(Random random) {
            byte[] bytes = new byte[16];
            random.nextBytes(bytes);
            return StringUtils.byteToHexString((byte[])bytes);
        }
    }
}

