/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import org.apache.flink.runtime.AbstractID;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SharedSlot;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class CoLocationConstraint {
    private final CoLocationGroup group;
    private volatile SharedSlot sharedSlot;

    CoLocationConstraint(CoLocationGroup group) {
        Preconditions.checkNotNull((Object)group);
        this.group = group;
    }

    public SharedSlot getSharedSlot() {
        return this.sharedSlot;
    }

    public Instance getLocation() {
        if (this.sharedSlot != null) {
            return this.sharedSlot.getInstance();
        }
        throw new IllegalStateException("Not assigned");
    }

    public void setSharedSlot(SharedSlot sharedSlot) {
        if (this.sharedSlot == sharedSlot) {
            return;
        }
        if (this.sharedSlot != null && !this.sharedSlot.isDead()) {
            throw new IllegalStateException("Overriding shared slot that is still alive.");
        }
        this.sharedSlot = sharedSlot;
    }

    public boolean isUnassigned() {
        return this.sharedSlot == null;
    }

    public boolean isUnassignedOrDisposed() {
        return this.sharedSlot == null || this.sharedSlot.isDead();
    }

    public AbstractID getGroupId() {
        return this.group.getId();
    }

    public String toString() {
        return "CoLocation constraint id " + this.getGroupId() + " shared slot " + this.sharedSlot;
    }
}

