/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.profiling.types;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.profiling.types.ProfilingEvent;

public abstract class VertexProfilingEvent
extends ProfilingEvent {
    private static final long serialVersionUID = -5364961557518174880L;
    private final JobVertexID vertexId;
    private int subtask;
    private final ExecutionAttemptID executionId;
    private int profilingInterval;

    public VertexProfilingEvent(JobVertexID vertexId, int subtask, ExecutionAttemptID executionId, int profilingInterval, JobID jobID, long timestamp, long profilingTimestamp) {
        super(jobID, timestamp, profilingTimestamp);
        this.vertexId = vertexId;
        this.subtask = subtask;
        this.executionId = executionId;
        this.profilingInterval = profilingInterval;
    }

    public VertexProfilingEvent() {
        this.vertexId = new JobVertexID();
        this.executionId = new ExecutionAttemptID();
    }

    public JobVertexID getVertexID() {
        return this.vertexId;
    }

    public int getProfilingInterval() {
        return this.profilingInterval;
    }

    public int getSubtask() {
        return this.subtask;
    }

    public ExecutionAttemptID getExecutionId() {
        return this.executionId;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.vertexId.read(in);
        this.executionId.read(in);
        this.subtask = in.readInt();
        this.profilingInterval = in.readInt();
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        this.vertexId.write(out);
        this.executionId.write(out);
        out.writeInt(this.subtask);
        out.writeInt(this.profilingInterval);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof VertexProfilingEvent) {
            VertexProfilingEvent other = (VertexProfilingEvent)obj;
            return super.equals(other) && this.subtask == other.subtask && this.profilingInterval == other.profilingInterval && this.vertexId.equals(other.vertexId) && this.executionId.equals(other.executionId);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.vertexId.hashCode() ^ 31 * this.subtask ^ this.executionId.hashCode();
    }
}

