/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.TraversableOnceException;

public final class KeyGroupedIteratorImmutable<E> {
    private final MutableObjectIterator<E> iterator;
    private final TypeSerializer<E> serializer;
    private final TypeComparator<E> comparator;
    private ValuesIterator valuesIterator;
    private E lastKeyRecord;
    private E lookahead;
    private boolean done;

    public KeyGroupedIteratorImmutable(MutableObjectIterator<E> iterator, TypeSerializer<E> serializer, TypeComparator<E> comparator) {
        if (iterator == null || serializer == null || comparator == null) {
            throw new NullPointerException();
        }
        this.iterator = iterator;
        this.serializer = serializer;
        this.comparator = comparator;
    }

    public boolean nextKey() throws IOException {
        if (this.lookahead != null) {
            this.comparator.setReference(this.lookahead);
            this.valuesIterator.next = this.lookahead;
            this.lastKeyRecord = this.lookahead;
            this.lookahead = null;
            this.valuesIterator.iteratorAvailable = true;
            return true;
        }
        if (this.done) {
            return false;
        }
        if (this.valuesIterator != null) {
            Object next = this.serializer.createInstance();
            while ((next = this.iterator.next(next)) != null) {
                if (this.comparator.equalToReference(next)) continue;
                this.comparator.setReference(next);
                this.valuesIterator.next = next;
                this.lastKeyRecord = next;
                this.valuesIterator.iteratorAvailable = true;
                return true;
            }
            this.valuesIterator.next = null;
            this.valuesIterator = null;
            this.lastKeyRecord = null;
            this.done = true;
            return false;
        }
        Object first = this.iterator.next(this.serializer.createInstance());
        if (first != null) {
            this.comparator.setReference(first);
            this.valuesIterator = new ValuesIterator(first);
            this.lastKeyRecord = first;
            return true;
        }
        this.done = true;
        return false;
    }

    private E advanceToNext() {
        try {
            Object next = this.iterator.next(this.serializer.createInstance());
            if (next != null) {
                if (this.comparator.equalToReference(next)) {
                    return (E)next;
                }
                this.lookahead = next;
                return null;
            }
            this.done = true;
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("An error occurred while reading the next record.", e);
        }
    }

    public E getCurrent() {
        return this.lastKeyRecord;
    }

    public TypeComparator<E> getComparatorWithCurrentReference() {
        return this.comparator;
    }

    public ValuesIterator getValues() {
        return this.valuesIterator;
    }

    public final class ValuesIterator
    implements Iterator<E>,
    Iterable<E> {
        private E next;
        private boolean iteratorAvailable = true;

        private ValuesIterator(E first) {
            this.next = first;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next != null) {
                Object current = this.next;
                this.next = KeyGroupedIteratorImmutable.this.advanceToNext();
                return current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            if (this.iteratorAvailable) {
                this.iteratorAvailable = false;
                return this;
            }
            throw new TraversableOnceException();
        }
    }
}

