/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequestBulk;

class PhysicalSlotRequestBulkImpl
implements PhysicalSlotRequestBulk {
    private final Map<SlotRequestId, ResourceProfile> pendingRequests;
    private final Map<SlotRequestId, AllocationID> fulfilledRequests = new HashMap<SlotRequestId, AllocationID>();
    private final BiConsumer<SlotRequestId, Throwable> canceller;

    PhysicalSlotRequestBulkImpl(Map<SlotRequestId, ResourceProfile> physicalSlotRequests, BiConsumer<SlotRequestId, Throwable> canceller) {
        this.pendingRequests = new HashMap<SlotRequestId, ResourceProfile>(physicalSlotRequests);
        this.canceller = canceller;
    }

    void markRequestFulfilled(SlotRequestId slotRequestId, AllocationID allocationID) {
        this.pendingRequests.remove((Object)slotRequestId);
        this.fulfilledRequests.put(slotRequestId, allocationID);
    }

    @Override
    public Collection<ResourceProfile> getPendingRequests() {
        return this.pendingRequests.values();
    }

    @Override
    public Set<AllocationID> getAllocationIdsOfFulfilledRequests() {
        return new HashSet<AllocationID>(this.fulfilledRequests.values());
    }

    @Override
    public void cancel(Throwable cause) {
        for (SlotRequestId slotRequestId : this.pendingRequests.keySet()) {
            this.canceller.accept(slotRequestId, cause);
        }
        for (SlotRequestId slotRequestId : this.fulfilledRequests.keySet()) {
            this.canceller.accept(slotRequestId, cause);
        }
    }
}

