/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.UUID;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.ResourceManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.SlotManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerProcessContext;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServices;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceManagerFactory<T extends ResourceIDRetrievable> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public ResourceManagerProcessContext createResourceManagerProcessContext(Configuration configuration, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, FatalErrorHandler fatalErrorHandler, ClusterInformation clusterInformation, @Nullable String webInterfaceUrl, MetricRegistry metricRegistry, String hostname, Executor ioExecutor) throws ConfigurationException {
        ResourceManagerMetricGroup resourceManagerMetricGroup = ResourceManagerMetricGroup.create(metricRegistry, hostname);
        SlotManagerMetricGroup slotManagerMetricGroup = SlotManagerMetricGroup.create(metricRegistry, hostname);
        Configuration runtimeServicesAndRmConfig = this.getEffectiveConfigurationForResourceManagerAndRuntimeServices(configuration);
        ResourceManagerRuntimeServicesConfiguration runtimeServiceConfig = this.createResourceManagerRuntimeServicesConfiguration(runtimeServicesAndRmConfig);
        Configuration rmConfig = this.getEffectiveConfigurationForResourceManager(runtimeServicesAndRmConfig);
        return new ResourceManagerProcessContext(rmConfig, runtimeServiceConfig, rpcService, highAvailabilityServices, heartbeatServices, fatalErrorHandler, clusterInformation, webInterfaceUrl, resourceManagerMetricGroup, slotManagerMetricGroup, ioExecutor);
    }

    public ResourceManager<T> createResourceManager(ResourceManagerProcessContext context, UUID leaderSessionId, ResourceID resourceId) throws Exception {
        ResourceManagerRuntimeServices resourceManagerRuntimeServices = this.createResourceManagerRuntimeServices(context.getRmRuntimeServicesConfig(), context.getRpcService(), context.getHighAvailabilityServices(), context.getSlotManagerMetricGroup());
        return this.createResourceManager(context.getRmConfig(), resourceId, context.getRpcService(), leaderSessionId, context.getHeartbeatServices(), context.getFatalErrorHandler(), context.getClusterInformation(), context.getWebInterfaceUrl(), context.getResourceManagerMetricGroup(), resourceManagerRuntimeServices, context.getIoExecutor());
    }

    protected Configuration getEffectiveConfigurationForResourceManagerAndRuntimeServices(Configuration configuration) {
        return configuration;
    }

    protected Configuration getEffectiveConfigurationForResourceManager(Configuration configuration) {
        return configuration;
    }

    protected abstract ResourceManager<T> createResourceManager(Configuration var1, ResourceID var2, RpcService var3, UUID var4, HeartbeatServices var5, FatalErrorHandler var6, ClusterInformation var7, @Nullable String var8, ResourceManagerMetricGroup var9, ResourceManagerRuntimeServices var10, Executor var11) throws Exception;

    private ResourceManagerRuntimeServices createResourceManagerRuntimeServices(ResourceManagerRuntimeServicesConfiguration rmRuntimeServicesConfig, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, SlotManagerMetricGroup slotManagerMetricGroup) {
        return ResourceManagerRuntimeServices.fromConfiguration(rmRuntimeServicesConfig, highAvailabilityServices, rpcService.getScheduledExecutor(), slotManagerMetricGroup);
    }

    protected abstract ResourceManagerRuntimeServicesConfiguration createResourceManagerRuntimeServicesConfiguration(Configuration var1) throws ConfigurationException;
}

