/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServerPutTest;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.blob.TestingFailingBlobServer;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BlobCacheRetriesTest
extends TestLogger {
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();

    @Test
    public void testBlobFetchRetries() throws IOException {
        BlobCacheRetriesTest.testBlobFetchRetries((BlobStore)new VoidBlobStore(), null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testBlobForJobFetchRetries() throws IOException {
        BlobCacheRetriesTest.testBlobFetchRetries((BlobStore)new VoidBlobStore(), new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testBlobFetchRetriesHa() throws IOException {
        Configuration config = new Configuration();
        config.setString(HighAvailabilityOptions.HA_MODE, "ZOOKEEPER");
        config.setString(HighAvailabilityOptions.HA_STORAGE_PATH, TEMPORARY_FOLDER.newFolder().getPath());
        BlobStoreService blobStoreService = null;
        try {
            blobStoreService = BlobUtils.createBlobStoreFromConfig((Configuration)config);
            BlobCacheRetriesTest.testBlobFetchRetries((BlobStore)blobStoreService, new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
        }
        finally {
            if (blobStoreService != null) {
                blobStoreService.closeAndCleanupAllData();
            }
        }
    }

    private static void testBlobFetchRetries(BlobStore blobStore, @Nullable JobID jobId, BlobKey.BlobType blobType) throws IOException {
        Configuration configuration = new Configuration();
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        try (TestingFailingBlobServer server = new TestingFailingBlobServer(configuration, TEMPORARY_FOLDER.newFolder(), blobStore, 2);
             BlobCacheService cache = new BlobCacheService(configuration, TEMPORARY_FOLDER.newFolder(), (BlobView)new VoidBlobStore(), new InetSocketAddress("localhost", server.getPort()));){
            server.start();
            BlobKey key = BlobServerPutTest.put((BlobService)server, jobId, data, blobType);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId, key, data);
        }
    }

    @Test
    public void testBlobNoJobFetchWithTooManyFailures() throws IOException {
        BlobCacheRetriesTest.testBlobFetchWithTooManyFailures((BlobStore)new VoidBlobStore(), null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testBlobForJobFetchWithTooManyFailures() throws IOException {
        BlobCacheRetriesTest.testBlobFetchWithTooManyFailures((BlobStore)new VoidBlobStore(), new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testBlobForJobFetchWithTooManyFailuresHa() throws IOException {
        Configuration config = new Configuration();
        config.setString(HighAvailabilityOptions.HA_MODE, "ZOOKEEPER");
        config.setString(HighAvailabilityOptions.HA_STORAGE_PATH, TEMPORARY_FOLDER.getRoot().getPath());
        BlobStoreService blobStoreService = null;
        try {
            blobStoreService = BlobUtils.createBlobStoreFromConfig((Configuration)config);
            BlobCacheRetriesTest.testBlobFetchWithTooManyFailures((BlobStore)blobStoreService, new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
        }
        finally {
            if (blobStoreService != null) {
                blobStoreService.closeAndCleanupAllData();
            }
        }
    }

    private static void testBlobFetchWithTooManyFailures(BlobStore blobStore, @Nullable JobID jobId, BlobKey.BlobType blobType) throws IOException {
        Configuration configuration = new Configuration();
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        try (TestingFailingBlobServer server = new TestingFailingBlobServer(configuration, TEMPORARY_FOLDER.newFolder(), blobStore, 0, 10);
             BlobCacheService cache = new BlobCacheService(configuration, TEMPORARY_FOLDER.newFolder(), (BlobView)new VoidBlobStore(), new InetSocketAddress("localhost", server.getPort()));){
            server.start();
            BlobKey key = BlobServerPutTest.put((BlobService)server, jobId, data, blobType);
            try {
                BlobServerPutTest.verifyContents((BlobService)cache, jobId, key, data);
                Assert.fail((String)"This should fail");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

