/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.util.StringUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;

public final class BlobKeyTest
extends TestLogger {
    private static final byte[] KEY_ARRAY_1;
    private static final byte[] KEY_ARRAY_2;
    private static final byte[] RANDOM_ARRAY_1;
    private static final byte[] RANDOM_ARRAY_2;

    @Test
    public void testCreateKey() {
        BlobKey key = BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB, (byte[])KEY_ARRAY_1);
        BlobKeyTest.verifyType(BlobKey.BlobType.PERMANENT_BLOB, key);
        Assert.assertArrayEquals((byte[])KEY_ARRAY_1, (byte[])key.getHash());
        key = BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.TRANSIENT_BLOB, (byte[])KEY_ARRAY_1);
        BlobKeyTest.verifyType(BlobKey.BlobType.TRANSIENT_BLOB, key);
        Assert.assertArrayEquals((byte[])KEY_ARRAY_1, (byte[])key.getHash());
    }

    @Test
    public void testSerializationTransient() throws Exception {
        this.testSerialization(BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testSerializationPermanent() throws Exception {
        this.testSerialization(BlobKey.BlobType.PERMANENT_BLOB);
    }

    private void testSerialization(BlobKey.BlobType blobType) throws Exception {
        BlobKey k1 = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_1);
        BlobKey k2 = (BlobKey)CommonTestUtils.createCopySerializable((Serializable)k1);
        Assert.assertEquals((Object)k1, (Object)k2);
        Assert.assertEquals((long)k1.hashCode(), (long)k2.hashCode());
        Assert.assertEquals((long)0L, (long)k1.compareTo(k2));
    }

    @Test
    public void testEqualsTransient() {
        this.testEquals(BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testEqualsPermanent() {
        this.testEquals(BlobKey.BlobType.PERMANENT_BLOB);
    }

    private void testEquals(BlobKey.BlobType blobType) {
        BlobKey k1 = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_1);
        BlobKey k2 = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_1);
        BlobKey k3 = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])KEY_ARRAY_2, (byte[])RANDOM_ARRAY_1);
        BlobKey k4 = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_2);
        Assert.assertTrue((boolean)k1.equals((Object)k2));
        Assert.assertTrue((boolean)k2.equals((Object)k1));
        Assert.assertEquals((long)k1.hashCode(), (long)k2.hashCode());
        Assert.assertFalse((boolean)k1.equals((Object)k3));
        Assert.assertFalse((boolean)k3.equals((Object)k1));
        Assert.assertFalse((boolean)k1.equals((Object)k4));
        Assert.assertFalse((boolean)k4.equals((Object)k1));
        Assert.assertFalse((boolean)k1.equals(null));
        Assert.assertFalse((boolean)k1.equals((Object)this));
    }

    @Test
    public void testEqualsDifferentBlobType() {
        BlobKey k1 = BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.TRANSIENT_BLOB, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_1);
        BlobKey k2 = BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_1);
        Assert.assertFalse((boolean)k1.equals((Object)k2));
        Assert.assertFalse((boolean)k2.equals((Object)k1));
    }

    @Test
    public void testComparesTransient() {
        this.testCompares(BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testComparesPermanent() {
        this.testCompares(BlobKey.BlobType.PERMANENT_BLOB);
    }

    private void testCompares(BlobKey.BlobType blobType) {
        BlobKey k1 = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_1);
        BlobKey k2 = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_1);
        BlobKey k3 = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])KEY_ARRAY_2, (byte[])RANDOM_ARRAY_1);
        BlobKey k4 = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_2);
        MatcherAssert.assertThat((Object)k1.compareTo(k2), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)k2.compareTo(k1), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)k1.compareTo(k3), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)k1.compareTo(k4), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)k3.compareTo(k1), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)k4.compareTo(k1), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void testComparesDifferentBlobType() {
        BlobKey k1 = BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.TRANSIENT_BLOB, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_1);
        BlobKey k2 = BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_1);
        MatcherAssert.assertThat((Object)k1.compareTo(k2), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)k2.compareTo(k1), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void testStreamsTransient() throws Exception {
        this.testStreams(BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testStreamsPermanent() throws Exception {
        this.testStreams(BlobKey.BlobType.PERMANENT_BLOB);
    }

    @Test
    public void testToFromStringPermanentKey() {
        this.testToFromString(BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB));
    }

    @Test
    public void testToFromStringTransientKey() {
        this.testToFromString(BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.TRANSIENT_BLOB));
    }

    private void testToFromString(BlobKey blobKey) {
        String stringRepresentation = blobKey.toString();
        BlobKey parsedBlobKey = BlobKey.fromString((String)stringRepresentation);
        MatcherAssert.assertThat((Object)blobKey, (Matcher)CoreMatchers.equalTo((Object)parsedBlobKey));
    }

    @Test(expected=IllegalStateException.class)
    public void testFromStringFailsWithWrongInput() {
        BlobKey.fromString((String)"foobar");
    }

    @Test(expected=IllegalStateException.class)
    public void testFromStringFailsWithInvalidBlobKeyType() {
        BlobKey.fromString((String)String.format("x-%s-%s", StringUtils.byteToHexString((byte[])KEY_ARRAY_1), StringUtils.byteToHexString((byte[])RANDOM_ARRAY_1)));
    }

    private void testStreams(BlobKey.BlobType blobType) throws IOException {
        BlobKey k1 = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(20);
        k1.writeToOutputStream((OutputStream)baos);
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        BlobKey k2 = BlobKey.readFromInputStream((InputStream)bais);
        Assert.assertEquals((Object)k1, (Object)k2);
    }

    static void verifyKeyDifferentHashEquals(BlobKey key1, BlobKey key2) {
        Assert.assertNotEquals((Object)key1, (Object)key2);
        MatcherAssert.assertThat((Object)key1.getHash(), (Matcher)CoreMatchers.equalTo((Object)key2.getHash()));
    }

    static void verifyKeyDifferentHashDifferent(BlobKey key1, BlobKey key2) {
        Assert.assertNotEquals((Object)key1, (Object)key2);
        MatcherAssert.assertThat((Object)key1.getHash(), (Matcher)IsNot.not((Matcher)CoreMatchers.equalTo((Object)key2.getHash())));
    }

    static void verifyType(BlobKey.BlobType expected, BlobKey key) {
        if (expected == BlobKey.BlobType.PERMANENT_BLOB) {
            MatcherAssert.assertThat((Object)key, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(PermanentBlobKey.class)));
        } else {
            MatcherAssert.assertThat((Object)key, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(TransientBlobKey.class)));
        }
    }

    static {
        int i;
        KEY_ARRAY_1 = new byte[20];
        KEY_ARRAY_2 = new byte[20];
        RANDOM_ARRAY_1 = new byte[16];
        RANDOM_ARRAY_2 = new byte[16];
        for (i = 0; i < KEY_ARRAY_1.length; ++i) {
            BlobKeyTest.KEY_ARRAY_1[i] = (byte)i;
            BlobKeyTest.KEY_ARRAY_2[i] = (byte)(i + 1);
        }
        for (i = 0; i < RANDOM_ARRAY_1.length; ++i) {
            BlobKeyTest.RANDOM_ARRAY_1[i] = (byte)i;
            BlobKeyTest.RANDOM_ARRAY_2[i] = (byte)(i + 1);
        }
    }
}

