/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.flink.runtime.io.network.partition.hybrid.BufferIndexAndChannel;
import org.apache.flink.runtime.io.network.partition.hybrid.HsSpillingInfoProvider;

public class TestingSpillingInfoProvider
implements HsSpillingInfoProvider {
    private final Supplier<List<Integer>> getNextBufferIndexToConsumeSupplier;
    private final Supplier<Integer> getNumTotalUnSpillBuffersSupplier;
    private final Supplier<Integer> getNumTotalRequestedBuffersSupplier;
    private final Supplier<Integer> getPoolSizeSupplier;
    private final Supplier<Integer> getNumSubpartitionsSupplier;
    private final Map<Integer, List<BufferIndexAndChannel>> allBuffers;
    private final Map<Integer, Set<Integer>> spillBufferIndexes;
    private final Map<Integer, Set<Integer>> consumedBufferIndexes;

    public TestingSpillingInfoProvider(Supplier<List<Integer>> getNextBufferIndexToConsumeSupplier, Supplier<Integer> getNumTotalUnSpillBuffersSupplier, Supplier<Integer> getNumTotalRequestedBuffersSupplier, Supplier<Integer> getPoolSizeSupplier, Supplier<Integer> getNumSubpartitionsSupplier, Map<Integer, List<BufferIndexAndChannel>> allBuffers, Map<Integer, Set<Integer>> spillBufferIndexes, Map<Integer, Set<Integer>> consumedBufferIndexes) {
        this.getNextBufferIndexToConsumeSupplier = getNextBufferIndexToConsumeSupplier;
        this.getNumTotalUnSpillBuffersSupplier = getNumTotalUnSpillBuffersSupplier;
        this.getNumTotalRequestedBuffersSupplier = getNumTotalRequestedBuffersSupplier;
        this.getPoolSizeSupplier = getPoolSizeSupplier;
        this.getNumSubpartitionsSupplier = getNumSubpartitionsSupplier;
        this.allBuffers = allBuffers;
        this.spillBufferIndexes = spillBufferIndexes;
        this.consumedBufferIndexes = consumedBufferIndexes;
    }

    public int getNumSubpartitions() {
        return this.getNumSubpartitionsSupplier.get();
    }

    public List<Integer> getNextBufferIndexToConsume() {
        return this.getNextBufferIndexToConsumeSupplier.get();
    }

    public Deque<BufferIndexAndChannel> getBuffersInOrder(int subpartitionId, HsSpillingInfoProvider.SpillStatus spillStatus, HsSpillingInfoProvider.ConsumeStatus consumeStatus) {
        ArrayDeque<BufferIndexAndChannel> buffersInOrder = new ArrayDeque<BufferIndexAndChannel>();
        List<BufferIndexAndChannel> subpartitionBuffers = this.allBuffers.get(subpartitionId);
        if (subpartitionBuffers == null) {
            return buffersInOrder;
        }
        for (int i = 0; i < subpartitionBuffers.size(); ++i) {
            if (!TestingSpillingInfoProvider.isBufferSatisfyStatus(spillStatus, consumeStatus, this.spillBufferIndexes.getOrDefault(subpartitionId, Collections.emptySet()).contains(i), this.consumedBufferIndexes.getOrDefault(subpartitionId, Collections.emptySet()).contains(i))) continue;
            buffersInOrder.add(subpartitionBuffers.get(i));
        }
        return buffersInOrder;
    }

    public int getNumTotalUnSpillBuffers() {
        return this.getNumTotalUnSpillBuffersSupplier.get();
    }

    public int getNumTotalRequestedBuffers() {
        return this.getNumTotalRequestedBuffersSupplier.get();
    }

    public int getPoolSize() {
        return this.getPoolSizeSupplier.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static boolean isBufferSatisfyStatus(HsSpillingInfoProvider.SpillStatus spillStatus, HsSpillingInfoProvider.ConsumeStatus consumeStatus, boolean isSpill, boolean isConsumed) {
        boolean isNeeded = true;
        switch (spillStatus) {
            case NOT_SPILL: {
                isNeeded = !isSpill;
                break;
            }
            case SPILL: {
                isNeeded = isSpill;
            }
        }
        switch (consumeStatus) {
            case NOT_CONSUMED: {
                isNeeded &= !isConsumed;
                break;
            }
            case CONSUMED: {
                isNeeded &= isConsumed;
            }
        }
        return isNeeded;
    }

    public static class Builder {
        private Supplier<List<Integer>> getNextBufferIndexToConsumeSupplier = ArrayList::new;
        private Supplier<Integer> getNumTotalUnSpillBuffersSupplier = () -> 0;
        private Supplier<Integer> getNumTotalRequestedBuffersSupplier = () -> 0;
        private Supplier<Integer> getPoolSizeSupplier = () -> 0;
        private Supplier<Integer> getNumSubpartitionsSupplier = () -> 0;
        private final Map<Integer, List<BufferIndexAndChannel>> allBuffers = new HashMap<Integer, List<BufferIndexAndChannel>>();
        private final Map<Integer, Set<Integer>> spillBufferIndexes = new HashMap<Integer, Set<Integer>>();
        private final Map<Integer, Set<Integer>> consumedBufferIndexes = new HashMap<Integer, Set<Integer>>();

        private Builder() {
        }

        public Builder setGetNextBufferIndexToConsumeSupplier(Supplier<List<Integer>> getNextBufferIndexToConsumeSupplier) {
            this.getNextBufferIndexToConsumeSupplier = getNextBufferIndexToConsumeSupplier;
            return this;
        }

        public Builder setGetNumTotalUnSpillBuffersSupplier(Supplier<Integer> getNumTotalUnSpillBuffersSupplier) {
            this.getNumTotalUnSpillBuffersSupplier = getNumTotalUnSpillBuffersSupplier;
            return this;
        }

        public Builder setGetNumTotalRequestedBuffersSupplier(Supplier<Integer> getNumTotalRequestedBuffersSupplier) {
            this.getNumTotalRequestedBuffersSupplier = getNumTotalRequestedBuffersSupplier;
            return this;
        }

        public Builder setGetPoolSizeSupplier(Supplier<Integer> getPoolSizeSupplier) {
            this.getPoolSizeSupplier = getPoolSizeSupplier;
            return this;
        }

        public Builder setGetNumSubpartitionsSupplier(Supplier<Integer> getNumSubpartitionsSupplier) {
            this.getNumSubpartitionsSupplier = getNumSubpartitionsSupplier;
            return this;
        }

        public Builder addSubpartitionBuffers(int subpartitionId, List<BufferIndexAndChannel> subpartitionBuffers) {
            this.allBuffers.computeIfAbsent(subpartitionId, ArrayList::new).addAll(subpartitionBuffers);
            return this;
        }

        public Builder addSpillBuffers(int subpartitionId, List<Integer> subpartitionSpillBufferIndexes) {
            this.spillBufferIndexes.computeIfAbsent(subpartitionId, HashSet::new).addAll(subpartitionSpillBufferIndexes);
            return this;
        }

        public Builder addConsumedBuffers(int subpartitionId, List<Integer> subpartitionConsumedBufferIndexes) {
            this.consumedBufferIndexes.computeIfAbsent(subpartitionId, HashSet::new).addAll(subpartitionConsumedBufferIndexes);
            return this;
        }

        public TestingSpillingInfoProvider build() {
            return new TestingSpillingInfoProvider(this.getNextBufferIndexToConsumeSupplier, this.getNumTotalUnSpillBuffersSupplier, this.getNumTotalRequestedBuffersSupplier, this.getPoolSizeSupplier, this.getNumSubpartitionsSupplier, this.allBuffers, this.spillBufferIndexes, this.consumedBufferIndexes);
        }
    }
}

