/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.runtime.jobmaster.JobManagerRunnerResult;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterServiceProcess;
import org.apache.flink.runtime.jobmaster.utils.TestingJobMasterGatewayBuilder;

public class TestingJobMasterServiceProcess
implements JobMasterServiceProcess {
    private final CompletableFuture<JobMasterGateway> jobMasterGatewayFuture;
    private final CompletableFuture<JobManagerRunnerResult> jobManagerRunnerResultFuture;
    private final CompletableFuture<String> leaderAddressFuture;
    private final boolean isInitialized;
    private final CompletableFuture<Void> terminationFuture;
    private final boolean manualTerminationFutureCompletion;

    private TestingJobMasterServiceProcess(CompletableFuture<JobMasterGateway> jobMasterGatewayFuture, CompletableFuture<JobManagerRunnerResult> jobManagerRunnerResultFuture, CompletableFuture<String> leaderAddressFuture, boolean isInitialized, CompletableFuture<Void> terminationFuture, boolean manualTerminationFutureCompletion) {
        this.jobMasterGatewayFuture = jobMasterGatewayFuture;
        this.jobManagerRunnerResultFuture = jobManagerRunnerResultFuture;
        this.leaderAddressFuture = leaderAddressFuture;
        this.isInitialized = isInitialized;
        this.terminationFuture = terminationFuture;
        this.manualTerminationFutureCompletion = manualTerminationFutureCompletion;
    }

    public CompletableFuture<Void> closeAsync() {
        if (!this.manualTerminationFutureCompletion) {
            this.terminationFuture.complete(null);
        }
        return this.terminationFuture;
    }

    public boolean isInitializedAndRunning() {
        return this.isInitialized && !this.terminationFuture.isDone();
    }

    public CompletableFuture<JobMasterGateway> getJobMasterGatewayFuture() {
        return this.jobMasterGatewayFuture;
    }

    public CompletableFuture<JobManagerRunnerResult> getResultFuture() {
        return this.jobManagerRunnerResultFuture;
    }

    public CompletableFuture<String> getLeaderAddressFuture() {
        return this.leaderAddressFuture;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private CompletableFuture<JobMasterGateway> jobMasterGatewayFuture = CompletableFuture.completedFuture(new TestingJobMasterGatewayBuilder().build());
        private CompletableFuture<JobManagerRunnerResult> jobManagerRunnerResultFuture = new CompletableFuture();
        private CompletableFuture<String> leaderAddressFuture = CompletableFuture.completedFuture("foobar");
        private boolean isInitialized = true;
        @Nullable
        private CompletableFuture<Void> terminationFuture = new CompletableFuture();
        private boolean manualTerminationFutureCompletion = false;

        public Builder setJobMasterGatewayFuture(CompletableFuture<JobMasterGateway> jobMasterGatewayFuture) {
            this.jobMasterGatewayFuture = jobMasterGatewayFuture;
            return this;
        }

        public Builder setJobManagerRunnerResultFuture(CompletableFuture<JobManagerRunnerResult> jobManagerRunnerResultFuture) {
            this.jobManagerRunnerResultFuture = jobManagerRunnerResultFuture;
            return this;
        }

        public Builder setLeaderAddressFuture(CompletableFuture<String> leaderAddressFuture) {
            this.leaderAddressFuture = leaderAddressFuture;
            return this;
        }

        public Builder setIsInitialized(boolean isInitialized) {
            this.isInitialized = isInitialized;
            return this;
        }

        public Builder setTerminationFuture(@Nullable CompletableFuture<Void> terminationFuture) {
            this.terminationFuture = terminationFuture;
            return this;
        }

        public Builder withManualTerminationFutureCompletion() {
            this.manualTerminationFutureCompletion = true;
            return this;
        }

        public TestingJobMasterServiceProcess build() {
            return new TestingJobMasterServiceProcess(this.jobMasterGatewayFuture, this.jobManagerRunnerResultFuture, this.leaderAddressFuture, this.isInitialized, this.terminationFuture, this.manualTerminationFutureCompletion);
        }
    }
}

