/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.net;

import java.io.File;
import java.io.InputStream;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLServerSocket;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.io.network.netty.SSLHandlerFactory;
import org.apache.flink.runtime.net.SSLUtils;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.buffer.UnpooledByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.OpenSsl;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslHandler;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SSLUtilsTest
extends TestLogger {
    private static final String TRUST_STORE_PATH = SSLUtilsTest.class.getResource("/local127.truststore").getFile();
    private static final String KEY_STORE_PATH = SSLUtilsTest.class.getResource("/local127.keystore").getFile();
    private static final String TRUST_STORE_PASSWORD = "password";
    private static final String KEY_STORE_PASSWORD = "password";
    private static final String KEY_PASSWORD = "password";
    public static final List<String> AVAILABLE_SSL_PROVIDERS;
    @Parameterized.Parameter
    public String sslProvider;

    @Parameterized.Parameters(name="SSL provider = {0}")
    public static List<String> parameters() {
        return AVAILABLE_SSL_PROVIDERS;
    }

    @Test
    public void testSocketFactoriesWhenSslDisabled() throws Exception {
        Configuration config = new Configuration();
        try {
            SSLUtils.createSSLServerSocketFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalConfigurationException illegalConfigurationException) {
            // empty catch block
        }
        try {
            SSLUtils.createSSLClientSocketFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalConfigurationException illegalConfigurationException) {
            // empty catch block
        }
    }

    @Test
    public void testRESTClientSSL() throws Exception {
        Configuration clientConfig = this.createRestSslConfigWithTrustStore();
        SSLHandlerFactory ssl = SSLUtils.createRestClientSSLEngineFactory((Configuration)clientConfig);
        Assert.assertNotNull((Object)ssl);
    }

    @Test
    public void testRESTClientSSLDisabled() throws Exception {
        Configuration clientConfig = this.createRestSslConfigWithTrustStore();
        clientConfig.setBoolean(SecurityOptions.SSL_REST_ENABLED, false);
        try {
            SSLUtils.createRestClientSSLEngineFactory((Configuration)clientConfig);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalConfigurationException illegalConfigurationException) {
            // empty catch block
        }
    }

    @Test
    public void testRESTClientSSLMissingTrustStore() throws Exception {
        Configuration config = new Configuration();
        config.setBoolean(SecurityOptions.SSL_REST_ENABLED, true);
        config.setString(SecurityOptions.SSL_REST_TRUSTSTORE_PASSWORD, "some password");
        try {
            SSLUtils.createRestClientSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalConfigurationException illegalConfigurationException) {
            // empty catch block
        }
    }

    @Test
    public void testRESTClientSSLMissingPassword() throws Exception {
        Configuration config = new Configuration();
        config.setBoolean(SecurityOptions.SSL_REST_ENABLED, true);
        config.setString(SecurityOptions.SSL_REST_TRUSTSTORE, TRUST_STORE_PATH);
        try {
            SSLUtils.createRestClientSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalConfigurationException illegalConfigurationException) {
            // empty catch block
        }
    }

    @Test
    public void testRESTClientSSLWrongPassword() throws Exception {
        Configuration clientConfig = this.createRestSslConfigWithTrustStore();
        clientConfig.setString(SecurityOptions.SSL_REST_TRUSTSTORE_PASSWORD, "badpassword");
        try {
            SSLUtils.createRestClientSSLEngineFactory((Configuration)clientConfig);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRESTServerSSL() throws Exception {
        Configuration serverConfig = this.createRestSslConfigWithKeyStore();
        SSLHandlerFactory ssl = SSLUtils.createRestServerSSLEngineFactory((Configuration)serverConfig);
        Assert.assertNotNull((Object)ssl);
    }

    @Test
    public void testRESTServerSSLDisabled() throws Exception {
        Configuration serverConfig = this.createRestSslConfigWithKeyStore();
        serverConfig.setBoolean(SecurityOptions.SSL_REST_ENABLED, false);
        try {
            SSLUtils.createRestServerSSLEngineFactory((Configuration)serverConfig);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalConfigurationException illegalConfigurationException) {
            // empty catch block
        }
    }

    @Test
    public void testRESTServerSSLBadKeystorePassword() {
        Configuration serverConfig = this.createRestSslConfigWithKeyStore();
        serverConfig.setString(SecurityOptions.SSL_REST_KEYSTORE_PASSWORD, "badpassword");
        try {
            SSLUtils.createRestServerSSLEngineFactory((Configuration)serverConfig);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRESTServerSSLBadKeyPassword() {
        Configuration serverConfig = this.createRestSslConfigWithKeyStore();
        serverConfig.setString(SecurityOptions.SSL_REST_KEY_PASSWORD, "badpassword");
        try {
            SSLUtils.createRestServerSSLEngineFactory((Configuration)serverConfig);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInternalSSL() throws Exception {
        Configuration config = this.createInternalSslConfigWithKeyAndTrustStores();
        Assert.assertNotNull((Object)SSLUtils.createInternalServerSSLEngineFactory((Configuration)config));
        Assert.assertNotNull((Object)SSLUtils.createInternalClientSSLEngineFactory((Configuration)config));
    }

    @Test
    public void testInternalSSLWithSSLPinning() throws Exception {
        Configuration config = this.createInternalSslConfigWithKeyAndTrustStores();
        config.setString(SecurityOptions.SSL_INTERNAL_CERT_FINGERPRINT, SSLUtilsTest.getCertificateFingerprint(config, "flink.test"));
        Assert.assertNotNull((Object)SSLUtils.createInternalServerSSLEngineFactory((Configuration)config));
        Assert.assertNotNull((Object)SSLUtils.createInternalClientSSLEngineFactory((Configuration)config));
    }

    @Test
    public void testInternalSSLDisables() throws Exception {
        Configuration config = this.createInternalSslConfigWithKeyAndTrustStores();
        config.setBoolean(SecurityOptions.SSL_INTERNAL_ENABLED, false);
        try {
            SSLUtils.createInternalServerSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SSLUtils.createInternalClientSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInternalSSLKeyStoreOnly() throws Exception {
        Configuration config = this.createInternalSslConfigWithKeyStore();
        try {
            SSLUtils.createInternalServerSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SSLUtils.createInternalClientSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInternalSSLTrustStoreOnly() throws Exception {
        Configuration config = this.createInternalSslConfigWithTrustStore();
        try {
            SSLUtils.createInternalServerSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SSLUtils.createInternalClientSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInternalSSLWrongKeystorePassword() throws Exception {
        Configuration config = this.createInternalSslConfigWithKeyAndTrustStores();
        config.setString(SecurityOptions.SSL_INTERNAL_KEYSTORE_PASSWORD, "badpw");
        try {
            SSLUtils.createInternalServerSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SSLUtils.createInternalClientSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInternalSSLWrongTruststorePassword() throws Exception {
        Configuration config = this.createInternalSslConfigWithKeyAndTrustStores();
        config.setString(SecurityOptions.SSL_INTERNAL_TRUSTSTORE_PASSWORD, "badpw");
        try {
            SSLUtils.createInternalServerSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SSLUtils.createInternalClientSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInternalSSLWrongKeyPassword() throws Exception {
        Configuration config = this.createInternalSslConfigWithKeyAndTrustStores();
        config.setString(SecurityOptions.SSL_INTERNAL_KEY_PASSWORD, "badpw");
        try {
            SSLUtils.createInternalServerSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SSLUtils.createInternalClientSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSetSSLVersionAndCipherSuitesForSSLServerSocket() throws Exception {
        Configuration serverConfig = this.createInternalSslConfigWithKeyAndTrustStores();
        serverConfig.setString(SecurityOptions.SSL_PROTOCOL, "TLSv1.1");
        serverConfig.setString(SecurityOptions.SSL_ALGORITHMS, "TLS_RSA_WITH_AES_128_CBC_SHA,TLS_RSA_WITH_AES_128_CBC_SHA256");
        try (ServerSocket socket = SSLUtils.createSSLServerSocketFactory((Configuration)serverConfig).createServerSocket(0);){
            Assert.assertTrue((boolean)(socket instanceof SSLServerSocket));
            SSLServerSocket sslSocket = (SSLServerSocket)socket;
            String[] protocols = sslSocket.getEnabledProtocols();
            String[] algorithms = sslSocket.getEnabledCipherSuites();
            Assert.assertEquals((long)1L, (long)protocols.length);
            Assert.assertEquals((Object)"TLSv1.1", (Object)protocols[0]);
            Assert.assertEquals((long)2L, (long)algorithms.length);
            Assert.assertThat((Object)algorithms, (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA256"}));
        }
    }

    @Test
    public void testCreateSSLEngineFactory() throws Exception {
        Object[] expectedSslProtocols;
        Object[] sslAlgorithms;
        Configuration serverConfig = this.createInternalSslConfigWithKeyAndTrustStores();
        if (this.sslProvider.equalsIgnoreCase("OPENSSL")) {
            sslAlgorithms = new String[]{"TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_GCM_SHA384"};
            expectedSslProtocols = new String[]{"SSLv2Hello", "TLSv1"};
        } else {
            sslAlgorithms = new String[]{"TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256"};
            expectedSslProtocols = new String[]{"TLSv1"};
        }
        serverConfig.setString(SecurityOptions.SSL_PROTOCOL, "TLSv1");
        serverConfig.setString(SecurityOptions.SSL_ALGORITHMS, String.join((CharSequence)",", (CharSequence[])sslAlgorithms));
        SSLHandlerFactory serverSSLHandlerFactory = SSLUtils.createInternalServerSSLEngineFactory((Configuration)serverConfig);
        SslHandler sslHandler = serverSSLHandlerFactory.createNettySSLHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assert.assertEquals((long)expectedSslProtocols.length, (long)sslHandler.engine().getEnabledProtocols().length);
        Assert.assertThat((Object)sslHandler.engine().getEnabledProtocols(), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])expectedSslProtocols));
        Assert.assertEquals((long)sslAlgorithms.length, (long)sslHandler.engine().getEnabledCipherSuites().length);
        Assert.assertThat((Object)sslHandler.engine().getEnabledCipherSuites(), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])sslAlgorithms));
    }

    @Test
    public void testInvalidFingerprintParsing() throws Exception {
        Configuration config = this.createInternalSslConfigWithKeyAndTrustStores();
        String fingerprint = SSLUtilsTest.getCertificateFingerprint(config, "flink.test");
        config.setString(SecurityOptions.SSL_INTERNAL_CERT_FINGERPRINT, fingerprint.substring(0, fingerprint.length() - 3));
        try {
            SSLUtils.createInternalServerSSLEngineFactory((Configuration)config);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"malformed fingerprint"));
        }
    }

    private Configuration createRestSslConfigWithKeyStore() {
        Configuration config = new Configuration();
        config.setBoolean(SecurityOptions.SSL_REST_ENABLED, true);
        SSLUtilsTest.addSslProviderConfig(config, this.sslProvider);
        SSLUtilsTest.addRestKeyStoreConfig(config);
        return config;
    }

    private Configuration createRestSslConfigWithTrustStore() {
        Configuration config = new Configuration();
        config.setBoolean(SecurityOptions.SSL_REST_ENABLED, true);
        SSLUtilsTest.addSslProviderConfig(config, this.sslProvider);
        SSLUtilsTest.addRestTrustStoreConfig(config);
        return config;
    }

    public static Configuration createRestSslConfigWithKeyAndTrustStores(String sslProvider) {
        Configuration config = new Configuration();
        config.setBoolean(SecurityOptions.SSL_REST_ENABLED, true);
        SSLUtilsTest.addSslProviderConfig(config, sslProvider);
        SSLUtilsTest.addRestKeyStoreConfig(config);
        SSLUtilsTest.addRestTrustStoreConfig(config);
        return config;
    }

    private Configuration createInternalSslConfigWithKeyStore() {
        Configuration config = new Configuration();
        config.setBoolean(SecurityOptions.SSL_INTERNAL_ENABLED, true);
        SSLUtilsTest.addSslProviderConfig(config, this.sslProvider);
        SSLUtilsTest.addInternalKeyStoreConfig(config);
        return config;
    }

    private Configuration createInternalSslConfigWithTrustStore() {
        Configuration config = new Configuration();
        config.setBoolean(SecurityOptions.SSL_INTERNAL_ENABLED, true);
        SSLUtilsTest.addSslProviderConfig(config, this.sslProvider);
        SSLUtilsTest.addInternalTrustStoreConfig(config);
        return config;
    }

    private Configuration createInternalSslConfigWithKeyAndTrustStores() {
        return SSLUtilsTest.createInternalSslConfigWithKeyAndTrustStores(this.sslProvider);
    }

    public static Configuration createInternalSslConfigWithKeyAndTrustStores(String sslProvider) {
        Configuration config = new Configuration();
        config.setBoolean(SecurityOptions.SSL_INTERNAL_ENABLED, true);
        SSLUtilsTest.addSslProviderConfig(config, sslProvider);
        SSLUtilsTest.addInternalKeyStoreConfig(config);
        SSLUtilsTest.addInternalTrustStoreConfig(config);
        return config;
    }

    public static String getCertificateFingerprint(Configuration config, String certificateAlias) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream keyStoreFile = Files.newInputStream(new File(config.getString(SecurityOptions.SSL_INTERNAL_KEYSTORE)).toPath(), new OpenOption[0]);){
            keyStore.load(keyStoreFile, config.getString(SecurityOptions.SSL_INTERNAL_KEYSTORE_PASSWORD).toCharArray());
        }
        return SSLUtilsTest.getSha1Fingerprint(keyStore.getCertificate(certificateAlias));
    }

    public static String getRestCertificateFingerprint(Configuration config, String certificateAlias) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream keyStoreFile = Files.newInputStream(new File(config.getString(SecurityOptions.SSL_REST_KEYSTORE)).toPath(), new OpenOption[0]);){
            keyStore.load(keyStoreFile, config.getString(SecurityOptions.SSL_REST_KEYSTORE_PASSWORD).toCharArray());
        }
        return SSLUtilsTest.getSha1Fingerprint(keyStore.getCertificate(certificateAlias));
    }

    private static void addSslProviderConfig(Configuration config, String sslProvider) {
        if (sslProvider.equalsIgnoreCase("OPENSSL")) {
            OpenSsl.ensureAvailability();
            config.setString(SecurityOptions.SSL_ALGORITHMS, "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384");
        }
        config.setString(SecurityOptions.SSL_PROVIDER, sslProvider);
    }

    private static void addRestKeyStoreConfig(Configuration config) {
        config.setString(SecurityOptions.SSL_REST_KEYSTORE, KEY_STORE_PATH);
        config.setString(SecurityOptions.SSL_REST_KEYSTORE_PASSWORD, "password");
        config.setString(SecurityOptions.SSL_REST_KEY_PASSWORD, "password");
    }

    private static void addRestTrustStoreConfig(Configuration config) {
        config.setString(SecurityOptions.SSL_REST_TRUSTSTORE, TRUST_STORE_PATH);
        config.setString(SecurityOptions.SSL_REST_TRUSTSTORE_PASSWORD, "password");
    }

    private static void addInternalKeyStoreConfig(Configuration config) {
        config.setString(SecurityOptions.SSL_INTERNAL_KEYSTORE, KEY_STORE_PATH);
        config.setString(SecurityOptions.SSL_INTERNAL_KEYSTORE_PASSWORD, "password");
        config.setString(SecurityOptions.SSL_INTERNAL_KEY_PASSWORD, "password");
    }

    private static void addInternalTrustStoreConfig(Configuration config) {
        config.setString(SecurityOptions.SSL_INTERNAL_TRUSTSTORE, TRUST_STORE_PATH);
        config.setString(SecurityOptions.SSL_INTERNAL_TRUSTSTORE_PASSWORD, "password");
    }

    private static String getSha1Fingerprint(Certificate cert) {
        if (cert == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            return SSLUtilsTest.toHexadecimalString(digest.digest(cert.getEncoded()));
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException generalSecurityException) {
            return null;
        }
    }

    private static String toHexadecimalString(byte[] value) {
        StringBuilder sb = new StringBuilder();
        int len = value.length;
        for (int i = 0; i < len; ++i) {
            int num = value[i] & 0xFF;
            if (num < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(num));
            if (i >= len - 1) continue;
            sb.append(':');
        }
        return sb.toString().toUpperCase(Locale.US);
    }

    static {
        if (System.getProperty("flink.tests.with-openssl") != null) {
            Assert.assertTrue((String)"openSSL not available but required (property 'flink.tests.with-openssl' is set)", (boolean)OpenSsl.isAvailable());
            AVAILABLE_SSL_PROVIDERS = Arrays.asList("JDK", "OPENSSL");
        } else {
            AVAILABLE_SSL_PROVIDERS = Collections.singletonList("JDK");
        }
    }
}

