/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.blocklist.BlocklistHandler;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.io.network.partition.ResourceManagerPartitionTrackerFactory;
import org.apache.flink.runtime.metrics.groups.ResourceManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.exceptions.ResourceManagerException;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.security.token.DelegationTokenManager;
import org.apache.flink.util.TimeUtils;

public class TestingResourceManager
extends ResourceManager<ResourceID> {
    private final Function<ResourceID, Boolean> stopWorkerFunction;
    private final CompletableFuture<Void> readyToServeFuture;

    public TestingResourceManager(RpcService rpcService, UUID leaderSessionId, ResourceID resourceId, HeartbeatServices heartbeatServices, DelegationTokenManager delegationTokenManager, SlotManager slotManager, ResourceManagerPartitionTrackerFactory clusterPartitionTrackerFactory, BlocklistHandler.Factory blocklistHandlerFactory, JobLeaderIdService jobLeaderIdService, FatalErrorHandler fatalErrorHandler, ResourceManagerMetricGroup resourceManagerMetricGroup, Function<ResourceID, Boolean> stopWorkerFunction, CompletableFuture<Void> readyToServeFuture) {
        super(rpcService, leaderSessionId, resourceId, heartbeatServices, delegationTokenManager, slotManager, clusterPartitionTrackerFactory, blocklistHandlerFactory, jobLeaderIdService, new ClusterInformation("localhost", 1234), fatalErrorHandler, resourceManagerMetricGroup, RpcUtils.INF_TIMEOUT, (Executor)ForkJoinPool.commonPool());
        this.stopWorkerFunction = stopWorkerFunction;
        this.readyToServeFuture = readyToServeFuture;
    }

    protected void initialize() throws ResourceManagerException {
    }

    protected void terminate() {
    }

    protected void internalDeregisterApplication(ApplicationStatus finalStatus, @Nullable String diagnostics) throws ResourceManagerException {
    }

    public boolean startNewWorker(WorkerResourceSpec workerResourceSpec) {
        return false;
    }

    protected ResourceID workerStarted(ResourceID resourceID) {
        return resourceID;
    }

    public boolean stopWorker(ResourceID worker) {
        return this.stopWorkerFunction.apply(worker);
    }

    public CompletableFuture<Void> getReadyToServeFuture() {
        return this.readyToServeFuture;
    }

    public <T> CompletableFuture<T> runInMainThread(Callable<T> callable, Time timeout) {
        return this.callAsync(callable, TimeUtils.toDuration((Time)timeout));
    }
}

