/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.compatibility;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.rest.compatibility.CompatibilityRoutine;
import org.apache.flink.runtime.rest.handler.RestHandlerSpecification;
import org.apache.flink.runtime.rest.messages.UntypedResponseMessageHeaders;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import org.apache.flink.util.jackson.JacksonMapperFactory;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;

enum CompatibilityRoutines {

    private static final CompatibilityRoutine<String> URL_ROUTINE = new CompatibilityRoutine<String>("url", String.class, RestHandlerSpecification::getTargetRestEndpointURL, (expected, actual) -> Assertions.assertThat((String)actual).isEqualTo(expected));
    private static final CompatibilityRoutine<String> METHOD_ROUTINE = new CompatibilityRoutine<String>("method", String.class, header -> header.getHttpMethod().getNettyHttpMethod().name(), (expected, actual) -> Assertions.assertThat((String)actual).isEqualTo(expected));
    private static final CompatibilityRoutine<String> STATUS_CODE_ROUTINE = new CompatibilityRoutine<String>("status-code", String.class, header -> header.getResponseStatusCode().toString(), (expected, actual) -> Assertions.assertThat((String)actual).isEqualTo(expected));
    private static final CompatibilityRoutine<Boolean> FILE_UPLOAD_ROUTINE = new CompatibilityRoutine<Boolean>("file-upload", Boolean.class, UntypedResponseMessageHeaders::acceptsFileUploads, (expected, actual) -> {
        AbstractBooleanAssert cfr_ignored_0 = (AbstractBooleanAssert)Assertions.assertThat((Boolean)actual).isEqualTo(expected);
    });
    private static final CompatibilityRoutine<PathParameterContainer> PATH_PARAMETER_ROUTINE = new CompatibilityRoutine<PathParameterContainer>("path-parameters", PathParameterContainer.class, header -> {
        List<PathParameterContainer.PathParameter> pathParameters = header.getUnresolvedMessageParameters().getPathParameters().stream().map(param -> new PathParameterContainer.PathParameter(param.getKey())).collect(Collectors.toList());
        return new PathParameterContainer(pathParameters);
    }, CompatibilityRoutines::assertCompatible);
    private static final CompatibilityRoutine<QueryParameterContainer> QUERY_PARAMETER_ROUTINE = new CompatibilityRoutine<QueryParameterContainer>("query-parameters", QueryParameterContainer.class, header -> {
        List<QueryParameterContainer.QueryParameter> pathParameters = header.getUnresolvedMessageParameters().getQueryParameters().stream().map(param -> new QueryParameterContainer.QueryParameter(param.getKey(), param.isMandatory())).collect(Collectors.toList());
        return new QueryParameterContainer(pathParameters);
    }, CompatibilityRoutines::assertCompatible);
    private static final CompatibilityRoutine<JsonNode> REQUEST_ROUTINE = new CompatibilityRoutine<JsonNode>("request", JsonNode.class, header -> CompatibilityRoutines.extractSchema(header.getRequestClass()), CompatibilityRoutines::assertCompatible);
    private static final CompatibilityRoutine<JsonNode> RESPONSE_ROUTINE = new CompatibilityRoutine<JsonNode>("response", JsonNode.class, header -> CompatibilityRoutines.extractSchema(header.getResponseClass()), CompatibilityRoutines::assertCompatible);
    static final Collection<CompatibilityRoutine<?>> ROUTINES = Collections.unmodifiableList(Arrays.asList(URL_ROUTINE, METHOD_ROUTINE, STATUS_CODE_ROUTINE, FILE_UPLOAD_ROUTINE, PATH_PARAMETER_ROUTINE, QUERY_PARAMETER_ROUTINE, REQUEST_ROUTINE, RESPONSE_ROUTINE));
    private static final ObjectMapper OBJECT_MAPPER = JacksonMapperFactory.createObjectMapper();
    private static final JsonSchemaGenerator SCHEMA_GENERATOR = new JsonSchemaGenerator(OBJECT_MAPPER);

    private static void assertCompatible(PathParameterContainer old, PathParameterContainer cur) {
        for (PathParameterContainer.PathParameter oldParam : old.pathParameters) {
            if (!cur.pathParameters.stream().noneMatch(param -> param.key.equals(oldParam.key))) continue;
            Assertions.fail((String)String.format("Existing Path parameter %s was removed.", oldParam.key));
        }
        for (PathParameterContainer.PathParameter curParam : cur.pathParameters) {
            if (!old.pathParameters.stream().noneMatch(param -> param.key.equals(curParam.key))) continue;
            Assertions.fail((String)String.format("New path parameter %s was added.", curParam.key));
        }
    }

    private static void assertCompatible(QueryParameterContainer old, QueryParameterContainer cur) {
        for (QueryParameterContainer.QueryParameter oldParam : old.queryParameters) {
            Optional<QueryParameterContainer.QueryParameter> matchingParameter = cur.queryParameters.stream().filter(param -> param.key.equals(oldParam.key)).findAny();
            if (matchingParameter.isPresent()) {
                QueryParameterContainer.QueryParameter newParam = matchingParameter.get();
                if (oldParam.mandatory || !newParam.mandatory) continue;
                Assertions.fail((String)String.format("Previously optional query parameter %s is now mandatory.", oldParam.key));
                continue;
            }
            Assertions.fail((String)String.format("Query parameter %s was removed.", oldParam.key));
        }
    }

    private static JsonNode extractSchema(Class<?> messageClass) {
        try {
            JsonSchema schema = SCHEMA_GENERATOR.generateSchema(messageClass);
            return OBJECT_MAPPER.valueToTree((Object)schema);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to generate message schema for class " + messageClass.getCanonicalName() + '.', e);
        }
    }

    private static void assertCompatible(JsonNode old, JsonNode cur) {
        ArrayDeque<Tuple2> stack = new ArrayDeque<Tuple2>(8);
        stack.add(Tuple2.of((Object)old, (Object)cur));
        while (!stack.isEmpty()) {
            Tuple2 propertyPair = (Tuple2)stack.pop();
            JsonNode oldProperty = (JsonNode)propertyPair.f0;
            JsonNode curProperty = (JsonNode)propertyPair.f1;
            ((IterableAssert)Assertions.assertThat((Iterable)curProperty).describedAs("Field %s was removed.", new Object[]{oldProperty})).isNotNull();
            String oldType = oldProperty.get("type").asText();
            String curType = curProperty.get("type").asText();
            if (!oldType.equals("any")) {
                ((AbstractStringAssert)Assertions.assertThat((String)curType).describedAs("Type of field was changed from '%s' to '%s'.", new Object[]{oldType, curType})).isEqualTo(oldType);
            }
            if (oldType.equals("array")) {
                JsonNode oldArrayItems = oldProperty.get("items");
                JsonNode curArrayItems = curProperty.get("items");
                stack.addLast(Tuple2.of((Object)oldArrayItems, (Object)curArrayItems));
                continue;
            }
            if (oldType.equals("object")) {
                JsonNode oldProperties = oldProperty.get("properties");
                JsonNode curProperties = curProperty.get("properties");
                if (oldProperties == null) continue;
                Iterator it = oldProperties.fields();
                while (it.hasNext()) {
                    Map.Entry oldPropertyWithKey = (Map.Entry)it.next();
                    stack.addLast(Tuple2.of(oldPropertyWithKey.getValue(), (Object)curProperties.get((String)oldPropertyWithKey.getKey())));
                }
                continue;
            }
            if (!oldType.equals("string")) continue;
            JsonNode oldEnumValues = oldProperty.get("enum");
            JsonNode curEnumValues = curProperty.get("enum");
            Assertions.assertThat((Iterable)curEnumValues).isEqualTo((Object)oldEnumValues);
        }
    }

    static final class QueryParameterContainer {
        public Collection<QueryParameter> queryParameters;

        private QueryParameterContainer() {
        }

        QueryParameterContainer(Collection<QueryParameter> queryParameters) {
            this.queryParameters = queryParameters;
        }

        static final class QueryParameter {
            public String key;
            public boolean mandatory;

            private QueryParameter() {
            }

            QueryParameter(String key, boolean mandatory) {
                this.key = key;
                this.mandatory = mandatory;
            }
        }
    }

    static final class PathParameterContainer {
        public Collection<PathParameter> pathParameters;

        private PathParameterContainer() {
        }

        PathParameterContainer(Collection<PathParameter> pathParameters) {
            this.pathParameters = pathParameters;
        }

        static final class PathParameter {
            public String key;

            private PathParameter() {
            }

            PathParameter(String key) {
                this.key = key;
            }
        }
    }
}

