/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.metrics.util.TestHistogram;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.messages.webmonitor.MultipleJobsDetails;
import org.apache.flink.runtime.metrics.dump.MetricDumpSerialization;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.dump.TestingMetricQueryServiceGateway;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcherImpl;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingRestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.Executors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class MetricFetcherTest
extends TestLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdate() {
        MetricStore store;
        Time timeout = Time.seconds((long)10L);
        JobID jobID = new JobID();
        ResourceID tmRID = ResourceID.generate();
        TestingMetricQueryServiceGateway jmQueryService = new TestingMetricQueryServiceGateway.Builder().setQueryMetricsSupplier(() -> CompletableFuture.completedFuture(new MetricDumpSerialization.MetricSerializationResult(new byte[0], new byte[0], new byte[0], new byte[0], 0, 0, 0, 0))).build();
        MetricDumpSerialization.MetricSerializationResult requestMetricsAnswer = MetricFetcherTest.createRequestDumpAnswer(tmRID, jobID);
        TestingMetricQueryServiceGateway tmQueryService = new TestingMetricQueryServiceGateway.Builder().setQueryMetricsSupplier(() -> CompletableFuture.completedFuture(requestMetricsAnswer)).build();
        TestingRestfulGateway restfulGateway = ((TestingRestfulGateway.Builder)((TestingRestfulGateway.Builder)((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setRequestMultipleJobDetailsSupplier(() -> CompletableFuture.completedFuture(new MultipleJobsDetails(Collections.emptyList())))).setRequestMetricQueryServiceGatewaysSupplier(() -> CompletableFuture.completedFuture(Collections.singleton(jmQueryService.getAddress())))).setRequestTaskManagerMetricQueryServiceGatewaysSupplier(() -> CompletableFuture.completedFuture(Collections.singleton(Tuple2.of((Object)tmRID, (Object)tmQueryService.getAddress()))))).build();
        GatewayRetriever retriever = () -> CompletableFuture.completedFuture(restfulGateway);
        MetricFetcherImpl fetcher = new MetricFetcherImpl(retriever, address -> CompletableFuture.completedFuture(tmQueryService), Executors.directExecutor(), timeout, ((Long)MetricOptions.METRIC_FETCHER_UPDATE_INTERVAL.defaultValue()).longValue());
        fetcher.update();
        MetricStore metricStore = store = fetcher.getMetricStore();
        synchronized (metricStore) {
            Assert.assertEquals((Object)"7", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_min"));
            Assert.assertEquals((Object)"6", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_max"));
            Assert.assertEquals((Object)"4.0", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_mean"));
            Assert.assertEquals((Object)"0.5", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_median"));
            Assert.assertEquals((Object)"5.0", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_stddev"));
            Assert.assertEquals((Object)"0.75", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_p75"));
            Assert.assertEquals((Object)"0.9", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_p90"));
            Assert.assertEquals((Object)"0.95", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_p95"));
            Assert.assertEquals((Object)"0.98", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_p98"));
            Assert.assertEquals((Object)"0.99", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_p99"));
            Assert.assertEquals((Object)"0.999", (Object)store.getJobManagerMetricStore().getMetric("abc.hist_p999"));
            Assert.assertEquals((Object)"x", store.getTaskManagerMetricStore((String)tmRID.toString()).metrics.get("abc.gauge"));
            Assert.assertEquals((Object)"5.0", store.getJobMetricStore((String)jobID.toString()).metrics.get("abc.jc"));
            Assert.assertEquals((Object)"2", store.getTaskMetricStore((String)jobID.toString(), (String)"taskid").metrics.get("2.abc.tc"));
            Assert.assertEquals((Object)"1", store.getTaskMetricStore((String)jobID.toString(), (String)"taskid").metrics.get("2.opname.abc.oc"));
        }
    }

    private static MetricDumpSerialization.MetricSerializationResult createRequestDumpAnswer(ResourceID tmRID, JobID jobID) {
        HashMap<SimpleCounter, Tuple2> counters = new HashMap<SimpleCounter, Tuple2>();
        HashMap<2, Tuple2> gauges = new HashMap<2, Tuple2>();
        HashMap<TestHistogram, Tuple2> histograms = new HashMap<TestHistogram, Tuple2>();
        HashMap<1, Tuple2> meters = new HashMap<1, Tuple2>();
        SimpleCounter c1 = new SimpleCounter();
        SimpleCounter c2 = new SimpleCounter();
        c1.inc(1L);
        c2.inc(2L);
        counters.put(c1, new Tuple2((Object)new QueryScopeInfo.OperatorQueryScopeInfo(jobID.toString(), "taskid", 2, 0, "opname", "abc"), (Object)"oc"));
        counters.put(c2, new Tuple2((Object)new QueryScopeInfo.TaskQueryScopeInfo(jobID.toString(), "taskid", 2, 0, "abc"), (Object)"tc"));
        meters.put(new Meter(){

            public void markEvent() {
            }

            public void markEvent(long n) {
            }

            public double getRate() {
                return 5.0;
            }

            public long getCount() {
                return 10L;
            }
        }, new Tuple2((Object)new QueryScopeInfo.JobQueryScopeInfo(jobID.toString(), "abc"), (Object)"jc"));
        gauges.put(new Gauge<String>(){

            public String getValue() {
                return "x";
            }
        }, new Tuple2((Object)new QueryScopeInfo.TaskManagerQueryScopeInfo(tmRID.toString(), "abc"), (Object)"gauge"));
        histograms.put(new TestHistogram(), new Tuple2((Object)new QueryScopeInfo.JobManagerQueryScopeInfo("abc"), (Object)"hist"));
        MetricDumpSerialization.MetricDumpSerializer serializer = new MetricDumpSerialization.MetricDumpSerializer();
        MetricDumpSerialization.MetricSerializationResult dump = serializer.serialize(counters, gauges, histograms, meters);
        serializer.close();
        return dump;
    }

    @Test
    public void testLongUpdateInterval() {
        long updateInterval = 1000L;
        AtomicInteger requestMetricQueryServiceGatewaysCounter = new AtomicInteger(0);
        RestfulGateway restfulGateway = this.createRestfulGateway(requestMetricQueryServiceGatewaysCounter);
        MetricFetcher fetcher = this.createMetricFetcher(1000L, restfulGateway);
        fetcher.update();
        fetcher.update();
        Assert.assertThat((Object)requestMetricQueryServiceGatewaysCounter.get(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testShortUpdateInterval() throws InterruptedException {
        long updateInterval = 1L;
        AtomicInteger requestMetricQueryServiceGatewaysCounter = new AtomicInteger(0);
        RestfulGateway restfulGateway = this.createRestfulGateway(requestMetricQueryServiceGatewaysCounter);
        MetricFetcher fetcher = this.createMetricFetcher(1L, restfulGateway);
        fetcher.update();
        long start = System.currentTimeMillis();
        long difference = 0L;
        while (difference <= 1L) {
            Thread.sleep(2L);
            difference = System.currentTimeMillis() - start;
        }
        fetcher.update();
        Assert.assertThat((Object)requestMetricQueryServiceGatewaysCounter.get(), (Matcher)Matchers.is((Object)2));
    }

    @Nonnull
    private MetricFetcher createMetricFetcher(long updateInterval, RestfulGateway restfulGateway) {
        return new MetricFetcherImpl(() -> CompletableFuture.completedFuture(restfulGateway), address -> null, Executors.directExecutor(), Time.seconds((long)10L), updateInterval);
    }

    private RestfulGateway createRestfulGateway(AtomicInteger requestMetricQueryServiceGatewaysCounter) {
        return ((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setRequestMetricQueryServiceGatewaysSupplier(() -> {
            requestMetricQueryServiceGatewaysCounter.incrementAndGet();
            return new CompletableFuture();
        })).build();
    }
}

