/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.InputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

class TestingInputsLocationsRetriever
implements InputsLocationsRetriever {
    private final Map<ExecutionVertexID, List<ExecutionVertexID>> producersByConsumer;
    private final Map<ExecutionVertexID, CompletableFuture<TaskManagerLocation>> taskManagerLocationsByVertex = new HashMap<ExecutionVertexID, CompletableFuture<TaskManagerLocation>>();

    TestingInputsLocationsRetriever(Map<ExecutionVertexID, List<ExecutionVertexID>> producersByConsumer) {
        this.producersByConsumer = new HashMap<ExecutionVertexID, List<ExecutionVertexID>>(producersByConsumer);
    }

    public Collection<Collection<ExecutionVertexID>> getConsumedResultPartitionsProducers(ExecutionVertexID executionVertexId) {
        Map<JobVertexID, List<ExecutionVertexID>> executionVerticesByJobVertex = this.producersByConsumer.getOrDefault(executionVertexId, Collections.emptyList()).stream().collect(Collectors.groupingBy(ExecutionVertexID::getJobVertexId));
        return new ArrayList<Collection<ExecutionVertexID>>(executionVerticesByJobVertex.values());
    }

    public Optional<CompletableFuture<TaskManagerLocation>> getTaskManagerLocation(ExecutionVertexID executionVertexId) {
        return Optional.ofNullable(this.taskManagerLocationsByVertex.get(executionVertexId));
    }

    public void markScheduled(ExecutionVertexID executionVertexId) {
        this.taskManagerLocationsByVertex.put(executionVertexId, new CompletableFuture());
    }

    public void assignTaskManagerLocation(ExecutionVertexID executionVertexId) {
        this.taskManagerLocationsByVertex.compute(executionVertexId, (key, future) -> {
            if (future == null) {
                return CompletableFuture.completedFuture(new LocalTaskManagerLocation());
            }
            future.complete(new LocalTaskManagerLocation());
            return future;
        });
    }

    void failTaskManagerLocation(ExecutionVertexID executionVertexId, Throwable cause) {
        this.taskManagerLocationsByVertex.compute(executionVertexId, (key, future) -> {
            CompletableFuture futureToFail = future;
            if (futureToFail == null) {
                futureToFail = new CompletableFuture();
            }
            futureToFail.completeExceptionally(cause);
            return futureToFail;
        });
    }

    void cancelTaskManagerLocation(ExecutionVertexID executionVertexId) {
        this.taskManagerLocationsByVertex.compute(executionVertexId, (key, future) -> {
            CompletableFuture futureToCancel = future;
            if (futureToCancel == null) {
                futureToCancel = new CompletableFuture();
            }
            futureToCancel.cancel(true);
            return futureToCancel;
        });
    }

    static class Builder {
        private final Map<ExecutionVertexID, List<ExecutionVertexID>> producersByConsumer = new HashMap<ExecutionVertexID, List<ExecutionVertexID>>();

        Builder() {
        }

        public Builder connectConsumerToProducer(ExecutionVertexID consumer, ExecutionVertexID producer) {
            this.producersByConsumer.computeIfAbsent(consumer, key -> new ArrayList()).add(producer);
            return this;
        }

        public TestingInputsLocationsRetriever build() {
            return new TestingInputsLocationsRetriever(this.producersByConsumer);
        }
    }
}

