/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.annotation.Nonnull;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.state.AsyncSnapshotCallable;
import org.apache.flink.util.Preconditions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AsyncSnapshotCallableTest {
    private static final String METHOD_CALL = "callInternal";
    private static final String METHOD_LOG = "logAsyncSnapshotComplete";
    private static final String METHOD_CLEANUP = "cleanupProvidedResources";
    private static final String METHOD_CANCEL = "cancel";
    private static final String SUCCESS = "Success!";
    private CloseableRegistry ownerRegistry;
    private TestBlockingCloseable testProvidedResource;
    private TestBlockingCloseable testBlocker;
    private TestAsyncSnapshotCallable testAsyncSnapshotCallable;
    private FutureTask<String> task;

    @Before
    public void setup() throws IOException {
        this.ownerRegistry = new CloseableRegistry();
        this.testProvidedResource = new TestBlockingCloseable();
        this.testBlocker = new TestBlockingCloseable();
        this.testAsyncSnapshotCallable = new TestAsyncSnapshotCallable(this.testProvidedResource, this.testBlocker);
        this.task = this.testAsyncSnapshotCallable.toAsyncSnapshotFutureTask(this.ownerRegistry);
        Assert.assertEquals((long)1L, (long)this.ownerRegistry.getNumberOfRegisteredCloseables());
    }

    @After
    public void finalChecks() {
        Assert.assertTrue((boolean)this.testProvidedResource.isClosed());
        Assert.assertEquals((long)0L, (long)this.ownerRegistry.getNumberOfRegisteredCloseables());
    }

    @Test
    public void testNormalRun() throws Exception {
        Thread runner = this.startTask(this.task);
        while (this.testBlocker.getWaitersCount() < 1) {
            Thread.sleep(1L);
        }
        this.testBlocker.unblockSuccessfully();
        runner.join();
        Assert.assertEquals((Object)SUCCESS, (Object)this.task.get());
        Assert.assertEquals(Arrays.asList(METHOD_CALL, METHOD_LOG, METHOD_CLEANUP), this.testAsyncSnapshotCallable.getInvocationOrder());
        Assert.assertTrue((boolean)this.testBlocker.isClosed());
    }

    @Test
    public void testExceptionRun() throws Exception {
        this.testBlocker.introduceException();
        Thread runner = this.startTask(this.task);
        while (this.testBlocker.getWaitersCount() < 1) {
            Thread.sleep(1L);
        }
        this.testBlocker.unblockSuccessfully();
        try {
            this.task.get();
            Assert.fail();
        }
        catch (ExecutionException ee) {
            Assert.assertEquals(IOException.class, ee.getCause().getClass());
        }
        runner.join();
        Assert.assertEquals(Arrays.asList(METHOD_CALL, METHOD_CLEANUP), this.testAsyncSnapshotCallable.getInvocationOrder());
        Assert.assertTrue((boolean)this.testBlocker.isClosed());
    }

    @Test
    public void testCancelRun() throws Exception {
        Thread runner = this.startTask(this.task);
        while (this.testBlocker.getWaitersCount() < 1) {
            Thread.sleep(1L);
        }
        this.task.cancel(true);
        this.testBlocker.unblockExceptionally();
        try {
            this.task.get();
            Assert.fail();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        runner.join();
        Assert.assertEquals(Arrays.asList(METHOD_CALL, METHOD_CANCEL, METHOD_CLEANUP), this.testAsyncSnapshotCallable.getInvocationOrder());
        Assert.assertTrue((boolean)this.testProvidedResource.isClosed());
        Assert.assertTrue((boolean)this.testBlocker.isClosed());
    }

    @Test
    public void testCloseRun() throws Exception {
        Thread runner = this.startTask(this.task);
        while (this.testBlocker.getWaitersCount() < 1) {
            Thread.sleep(1L);
        }
        this.ownerRegistry.close();
        try {
            this.task.get();
            Assert.fail();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        runner.join();
        Assert.assertEquals(Arrays.asList(METHOD_CALL, METHOD_CANCEL, METHOD_CLEANUP), this.testAsyncSnapshotCallable.getInvocationOrder());
        Assert.assertTrue((boolean)this.testBlocker.isClosed());
    }

    @Test
    public void testCancelBeforeRun() throws Exception {
        this.task.cancel(true);
        Thread runner = this.startTask(this.task);
        try {
            this.task.get();
            Assert.fail();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        runner.join();
        Assert.assertEquals(Arrays.asList(METHOD_CANCEL, METHOD_CLEANUP), this.testAsyncSnapshotCallable.getInvocationOrder());
        Assert.assertTrue((boolean)this.testProvidedResource.isClosed());
    }

    private Thread startTask(Runnable task) {
        Thread runner = new Thread(task);
        runner.start();
        return runner;
    }

    private static class TestBlockingCloseable
    implements Closeable {
        private final OneShotLatch blockerLatch = new OneShotLatch();
        private boolean closed = false;
        private boolean unblocked = false;
        private boolean exceptionally = false;

        private TestBlockingCloseable() {
        }

        public void simulateBlockingOperation() throws IOException {
            while (!this.unblocked) {
                try {
                    this.blockerLatch.await();
                }
                catch (InterruptedException e) {
                    this.blockerLatch.reset();
                }
            }
            if (this.exceptionally) {
                throw new IOException("Closed in block");
            }
        }

        @Override
        public void close() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
            this.closed = true;
            this.unblockExceptionally();
        }

        public boolean isClosed() {
            return this.closed;
        }

        public void unblockExceptionally() {
            this.introduceException();
            this.unblock();
        }

        public void unblockSuccessfully() {
            this.unblock();
        }

        private void unblock() {
            this.unblocked = true;
            this.blockerLatch.trigger();
        }

        public void introduceException() {
            this.exceptionally = true;
        }

        public int getWaitersCount() {
            return this.blockerLatch.getWaitersCount();
        }
    }

    private static class TestAsyncSnapshotCallable
    extends AsyncSnapshotCallable<String> {
        @Nonnull
        private final TestBlockingCloseable providedResource;
        @Nonnull
        private final TestBlockingCloseable blockingResource;
        @Nonnull
        private final List<String> invocationOrder;

        TestAsyncSnapshotCallable(@Nonnull TestBlockingCloseable providedResource, @Nonnull TestBlockingCloseable blockingResource) {
            this.providedResource = providedResource;
            this.blockingResource = blockingResource;
            this.invocationOrder = new ArrayList<String>();
        }

        protected String callInternal() throws Exception {
            this.addInvocation(AsyncSnapshotCallableTest.METHOD_CALL);
            this.snapshotCloseableRegistry.registerCloseable((AutoCloseable)this.blockingResource);
            try {
                this.blockingResource.simulateBlockingOperation();
            }
            finally {
                if (this.snapshotCloseableRegistry.unregisterCloseable((AutoCloseable)this.blockingResource)) {
                    this.blockingResource.close();
                }
            }
            return AsyncSnapshotCallableTest.SUCCESS;
        }

        protected void cleanupProvidedResources() {
            this.addInvocation(AsyncSnapshotCallableTest.METHOD_CLEANUP);
            this.providedResource.close();
        }

        protected void logAsyncSnapshotComplete(long startTime) {
            this.invocationOrder.add(AsyncSnapshotCallableTest.METHOD_LOG);
        }

        protected void cancel() {
            this.addInvocation(AsyncSnapshotCallableTest.METHOD_CANCEL);
            super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        public List<String> getInvocationOrder() {
            List<String> list = this.invocationOrder;
            synchronized (list) {
                return new ArrayList<String>(this.invocationOrder);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addInvocation(@Nonnull String invocation) {
            List<String> list = this.invocationOrder;
            synchronized (list) {
                this.invocationOrder.add(invocation);
            }
        }
    }
}

