/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.bash;

import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.util.bash.BashJavaUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class BashJavaUtilsTest
extends TestLogger {
    @Test
    public void testJmLegacyHeapOptionSetsNewJvmHeap() {
        Configuration configuration = new Configuration();
        MemorySize heapSize = MemorySize.ofMebiBytes((long)10L);
        configuration.set(JobManagerOptions.JOB_MANAGER_HEAP_MEMORY, (Object)heapSize);
        String jvmArgsLine = (String)BashJavaUtils.getJmResourceParams((Configuration)configuration).get(0);
        Map jvmArgs = ConfigurationUtils.parseJvmArgString((String)jvmArgsLine);
        String heapSizeStr = Long.toString(heapSize.getBytes());
        Assert.assertThat(jvmArgs.get("-Xmx"), (Matcher)CoreMatchers.is((Object)heapSizeStr));
        Assert.assertThat(jvmArgs.get("-Xms"), (Matcher)CoreMatchers.is((Object)heapSizeStr));
    }
}

