/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blocklist;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.runtime.blocklist.BlockedNode;
import org.apache.flink.runtime.blocklist.BlockedNodeAdditionResult;
import org.apache.flink.runtime.blocklist.DefaultBlocklistTracker;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultBlocklistTrackerTest {
    DefaultBlocklistTrackerTest() {
    }

    @Test
    void testAddNewBlockedNodes() {
        BlockedNode blockedNode1 = new BlockedNode("node1", "cause1", 1L);
        BlockedNode blockedNode2 = new BlockedNode("node2", "cause1", 1L);
        BlockedNode blockedNode3 = new BlockedNode("node3", "cause1", 1L);
        DefaultBlocklistTracker blocklistTracker = new DefaultBlocklistTracker();
        blocklistTracker.addNewBlockedNodes(Arrays.asList(blockedNode1, blockedNode2, blockedNode3));
        Assertions.assertThat((Collection)blocklistTracker.getAllBlockedNodeIds()).containsExactlyInAnyOrder((Object[])new String[]{"node1", "node2", "node3"});
        BlockedNode blockedNode4 = new BlockedNode("node4", "cause1", 1L);
        BlockedNode blockedNode5 = new BlockedNode("node2", "cause2", 2L);
        BlockedNode blockedNode6 = new BlockedNode("node3", "cause1", 1L);
        BlockedNodeAdditionResult result = blocklistTracker.addNewBlockedNodes(Arrays.asList(blockedNode4, blockedNode5, blockedNode6));
        Assertions.assertThat((Collection)result.getNewlyAddedNodes()).containsExactly((Object[])new BlockedNode[]{blockedNode4});
        Assertions.assertThat((Collection)result.getMergedNodes()).containsExactly((Object[])new BlockedNode[]{blockedNode5});
        Assertions.assertThat((Collection)blocklistTracker.getAllBlockedNodes()).containsExactlyInAnyOrder((Object[])new BlockedNode[]{blockedNode1, blockedNode3, blockedNode4, blockedNode5});
        BlockedNode blockedNode7 = new BlockedNode("node3", "cause2", 1L);
        result = blocklistTracker.addNewBlockedNodes(Collections.singletonList(blockedNode7));
        Assertions.assertThat((Collection)result.getNewlyAddedNodes()).isEmpty();
        Assertions.assertThat((Collection)result.getMergedNodes()).containsExactly((Object[])new BlockedNode[]{blockedNode7});
        Assertions.assertThat((Collection)blocklistTracker.getAllBlockedNodes()).containsExactlyInAnyOrder((Object[])new BlockedNode[]{blockedNode1, blockedNode4, blockedNode5, blockedNode7});
    }

    @Test
    void testRemoveTimeoutNodes() {
        BlockedNode blockedNode1 = new BlockedNode("node1", "cause1", 1L);
        BlockedNode blockedNode2 = new BlockedNode("node2", "cause1", 2L);
        BlockedNode blockedNode3 = new BlockedNode("node3", "cause1", 3L);
        DefaultBlocklistTracker blocklistTracker = new DefaultBlocklistTracker();
        blocklistTracker.addNewBlockedNodes(Arrays.asList(blockedNode1, blockedNode2, blockedNode3));
        Assertions.assertThat((Collection)blocklistTracker.getAllBlockedNodeIds()).containsExactlyInAnyOrder((Object[])new String[]{"node1", "node2", "node3"});
        Collection removedNodes = blocklistTracker.removeTimeoutNodes(2L);
        Assertions.assertThat((Collection)removedNodes).containsExactlyInAnyOrder((Object[])new BlockedNode[]{blockedNode1, blockedNode2});
        Assertions.assertThat((Collection)blocklistTracker.getAllBlockedNodeIds()).containsExactlyInAnyOrder((Object[])new String[]{"node3"});
    }
}

