/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.jobmanager.JobManagerProcessSpec;
import org.apache.flink.runtime.jobmanager.JobManagerProcessUtils;
import org.apache.flink.runtime.util.config.memory.ProcessMemoryUtilsTestBase;
import org.apache.flink.runtime.util.config.memory.jobmanager.JobManagerFlinkMemoryUtils;
import org.apache.flink.testutils.logging.TestLoggerResource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsArrayWithSize;
import org.hamcrest.collection.IsMapContaining;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.event.Level;

public class JobManagerProcessUtilsTest
extends ProcessMemoryUtilsTestBase<JobManagerProcessSpec> {
    private static final MemorySize JVM_HEAP_SIZE = MemorySize.parse((String)"1152m");
    private static final MemorySize TOTAL_FLINK_MEM_SIZE = MemorySize.parse((String)"1280m");
    private static final MemorySize TOTAL_PROCESS_MEM_SIZE = MemorySize.parse((String)"1536m");
    @Rule
    public final TestLoggerResource testLoggerResource = new TestLoggerResource(JobManagerFlinkMemoryUtils.class, Level.INFO);

    public JobManagerProcessUtilsTest() {
        super(JobManagerProcessUtils.JM_PROCESS_MEMORY_OPTIONS, JobManagerProcessUtils.JM_LEGACY_HEAP_OPTIONS, (ConfigOption<MemorySize>)JobManagerOptions.TOTAL_PROCESS_MEMORY);
    }

    @Test
    public void testGenerateDynamicConfigurations() {
        Configuration config = new Configuration();
        config.set(JobManagerOptions.JVM_HEAP_MEMORY, (Object)MemorySize.parse((String)"1m"));
        config.set(JobManagerOptions.OFF_HEAP_MEMORY, (Object)MemorySize.parse((String)"2m"));
        config.set(JobManagerOptions.JVM_METASPACE, (Object)MemorySize.parse((String)"3m"));
        config.set(JobManagerOptions.JVM_OVERHEAD_MIN, (Object)MemorySize.parse((String)"4m"));
        config.set(JobManagerOptions.JVM_OVERHEAD_MAX, (Object)MemorySize.parse((String)"5m"));
        JobManagerProcessSpec jobManagerProcessSpec = JobManagerProcessUtils.processSpecFromConfig((Configuration)config);
        String dynamicConfigsStr = JobManagerProcessUtils.generateDynamicConfigsStr((JobManagerProcessSpec)jobManagerProcessSpec);
        Map<String, String> configs = JobManagerProcessUtilsTest.parseAndAssertJobManagerResourceDynamicConfig(dynamicConfigsStr);
        Assert.assertThat((Object)MemorySize.parse((String)configs.get(JobManagerOptions.JVM_HEAP_MEMORY.key())), (Matcher)Matchers.is((Object)jobManagerProcessSpec.getJvmHeapMemorySize()));
        Assert.assertThat((Object)MemorySize.parse((String)configs.get(JobManagerOptions.OFF_HEAP_MEMORY.key())), (Matcher)Matchers.is((Object)jobManagerProcessSpec.getJvmDirectMemorySize()));
        Assert.assertThat((Object)MemorySize.parse((String)configs.get(JobManagerOptions.JVM_METASPACE.key())), (Matcher)Matchers.is((Object)jobManagerProcessSpec.getJvmMetaspaceSize()));
        Assert.assertThat((Object)MemorySize.parse((String)configs.get(JobManagerOptions.JVM_OVERHEAD_MIN.key())), (Matcher)Matchers.is((Object)jobManagerProcessSpec.getJvmOverheadSize()));
        Assert.assertThat((Object)MemorySize.parse((String)configs.get(JobManagerOptions.JVM_OVERHEAD_MAX.key())), (Matcher)Matchers.is((Object)jobManagerProcessSpec.getJvmOverheadSize()));
    }

    private static Map<String, String> parseAndAssertJobManagerResourceDynamicConfig(String dynamicParameterStr) {
        HashMap<String, String> config = new HashMap<String, String>();
        String[] dynamicParameterTokens = dynamicParameterStr.split(" ");
        Assert.assertThat((Object)(dynamicParameterTokens.length % 2), (Matcher)Matchers.is((Object)0));
        for (int i = 0; i < dynamicParameterTokens.length; ++i) {
            String configStr = dynamicParameterTokens[i];
            if (i % 2 == 0) {
                Assert.assertThat((Object)configStr, (Matcher)Matchers.is((Object)"-D"));
                continue;
            }
            String[] configEntry = configStr.split("=");
            Assert.assertThat((Object)configEntry, (Matcher)IsArrayWithSize.arrayWithSize((int)2));
            config.put(configEntry[0], configEntry[1]);
        }
        Assert.assertThat(config, (Matcher)IsMapContaining.hasKey((Object)JobManagerOptions.JVM_HEAP_MEMORY.key()));
        Assert.assertThat(config, (Matcher)IsMapContaining.hasKey((Object)JobManagerOptions.OFF_HEAP_MEMORY.key()));
        Assert.assertThat(config, (Matcher)IsMapContaining.hasKey((Object)JobManagerOptions.JVM_METASPACE.key()));
        Assert.assertThat(config, (Matcher)IsMapContaining.hasKey((Object)JobManagerOptions.JVM_OVERHEAD_MIN.key()));
        Assert.assertThat(config, (Matcher)IsMapContaining.hasKey((Object)JobManagerOptions.JVM_OVERHEAD_MAX.key()));
        return config;
    }

    @Test
    public void testConfigJvmHeapMemory() {
        MemorySize jvmHeapSize = MemorySize.parse((String)"50m");
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.JVM_HEAP_MEMORY, (Object)jvmHeapSize);
        JobManagerProcessSpec jobManagerProcessSpec = JobManagerProcessUtils.processSpecFromConfig((Configuration)conf);
        Assert.assertThat((Object)jobManagerProcessSpec.getJvmHeapMemorySize(), (Matcher)Matchers.is((Object)jvmHeapSize));
    }

    @Test
    public void testLogFailureOfJvmHeapSizeMinSizeVerification() {
        MemorySize jvmHeapMemory = MemorySize.parse((String)"50m");
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.JVM_HEAP_MEMORY, (Object)jvmHeapMemory);
        JobManagerProcessUtils.processSpecFromConfig((Configuration)conf);
        MatcherAssert.assertThat((Object)this.testLoggerResource.getMessages(), (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.containsString((String)String.format("The configured or derived JVM heap memory size (%s) is less than its recommended minimum value (%s)", jvmHeapMemory.toHumanReadableString(), JobManagerOptions.MIN_JVM_HEAP_SIZE.toHumanReadableString()))));
    }

    @Test
    public void testConfigOffHeapMemory() {
        MemorySize offHeapMemory = MemorySize.parse((String)"100m");
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.OFF_HEAP_MEMORY, (Object)offHeapMemory);
        this.validateInAllConfigurationsWithoutExplicitTotalFlinkAndJvmHeapMem(conf, jobManagerProcessSpec -> Assert.assertThat((Object)jobManagerProcessSpec.getJvmDirectMemorySize(), (Matcher)Matchers.is((Object)offHeapMemory)));
    }

    @Test
    public void testFlinkInternalMemorySizeAddUpFailure() {
        MemorySize totalFlinkMemory = MemorySize.parse((String)"199m");
        MemorySize jvmHeap = MemorySize.parse((String)"100m");
        MemorySize offHeapMemory = MemorySize.parse((String)"100m");
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.TOTAL_FLINK_MEMORY, (Object)totalFlinkMemory);
        conf.set(JobManagerOptions.JVM_HEAP_MEMORY, (Object)jvmHeap);
        conf.set(JobManagerOptions.OFF_HEAP_MEMORY, (Object)offHeapMemory);
        this.validateFail(conf);
    }

    @Test
    public void testJvmHeapExceedsTotalFlinkMemoryFailure() {
        MemorySize totalFlinkMemory = MemorySize.ofMebiBytes((long)100L);
        MemorySize jvmHeap = MemorySize.ofMebiBytes((long)150L);
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.TOTAL_FLINK_MEMORY, (Object)totalFlinkMemory);
        conf.set(JobManagerOptions.JVM_HEAP_MEMORY, (Object)jvmHeap);
        this.validateFail(conf);
    }

    @Test
    public void testOffHeapMemoryDerivedFromJvmHeapAndTotalFlinkMemory() {
        MemorySize jvmHeap = MemorySize.ofMebiBytes((long)150L);
        MemorySize defaultOffHeap = (MemorySize)JobManagerOptions.OFF_HEAP_MEMORY.defaultValue();
        MemorySize expectedOffHeap = MemorySize.ofMebiBytes((long)100L).add(defaultOffHeap);
        MemorySize totalFlinkMemory = jvmHeap.add(expectedOffHeap);
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.TOTAL_FLINK_MEMORY, (Object)totalFlinkMemory);
        conf.set(JobManagerOptions.JVM_HEAP_MEMORY, (Object)jvmHeap);
        JobManagerProcessSpec jobManagerProcessSpec = JobManagerProcessUtils.processSpecFromConfig((Configuration)conf);
        Assert.assertThat((Object)jobManagerProcessSpec.getJvmDirectMemorySize(), (Matcher)Matchers.is((Object)expectedOffHeap));
        MatcherAssert.assertThat((Object)this.testLoggerResource.getMessages(), (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.containsString((String)String.format("The Off-Heap Memory size (%s) is derived the configured Total Flink Memory size (%s) minus the configured JVM Heap Memory size (%s). The default Off-Heap Memory size (%s) is ignored.", expectedOffHeap.toHumanReadableString(), totalFlinkMemory.toHumanReadableString(), jvmHeap.toHumanReadableString(), defaultOffHeap.toHumanReadableString()))));
    }

    @Test
    public void testDeriveFromRequiredFineGrainedOptions() {
        MemorySize jvmHeap = MemorySize.ofMebiBytes((long)150L);
        MemorySize offHeap = MemorySize.ofMebiBytes((long)50L);
        MemorySize totalFlinkMemory = MemorySize.ofMebiBytes((long)200L);
        MemorySize expectedOffHeap = MemorySize.ofMebiBytes((long)50L);
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.TOTAL_FLINK_MEMORY, (Object)totalFlinkMemory);
        conf.set(JobManagerOptions.OFF_HEAP_MEMORY, (Object)offHeap);
        conf.set(JobManagerOptions.JVM_HEAP_MEMORY, (Object)jvmHeap);
        JobManagerProcessSpec jobManagerProcessSpec = JobManagerProcessUtils.processSpecFromConfig((Configuration)conf);
        Assert.assertThat((Object)jobManagerProcessSpec.getJvmDirectMemorySize(), (Matcher)Matchers.is((Object)expectedOffHeap));
    }

    @Override
    protected JobManagerProcessSpec processSpecFromConfig(Configuration config) {
        return JobManagerProcessUtils.processSpecFromConfig((Configuration)config);
    }

    @Override
    protected Configuration getConfigurationWithLegacyHeapSizeMappedToNewConfigOption(Configuration config) {
        return JobManagerProcessUtils.getConfigurationWithLegacyHeapSizeMappedToNewConfigOption((Configuration)config, this.getNewOptionForLegacyHeapOption());
    }

    @Override
    protected void validateInAllConfigurations(Configuration customConfig, Consumer<JobManagerProcessSpec> validateFunc) {
        this.validateInConfigWithExplicitJvmHeap(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalFlinkMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalFlinkAndJvmHeapMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalProcessMem(customConfig, validateFunc);
    }

    @Override
    protected void validateFailInAllConfigurations(Configuration customConfig) {
        this.validateFailInConfigWithExplicitJvmHeap(customConfig);
        this.validateFailInConfigWithExplicitTotalFlinkMem(customConfig);
        this.validateFailInConfigWithExplicitTotalFlinkAndJvmHeapMem(customConfig);
        this.validateFailInConfigWithExplicitTotalProcessMem(customConfig);
    }

    private void validateInAllConfigurationsWithoutExplicitTotalFlinkAndJvmHeapMem(Configuration customConfig, Consumer<JobManagerProcessSpec> validateFunc) {
        this.validateInConfigWithExplicitJvmHeap(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalFlinkMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalProcessMem(customConfig, validateFunc);
    }

    private void validateInConfigWithExplicitJvmHeap(Configuration customConfig, Consumer<JobManagerProcessSpec> validateFunc) {
        this.log.info("Validating in configuration with explicit jvm heap.");
        Configuration config = JobManagerProcessUtilsTest.configWithExplicitJvmHeap();
        config.addAll(customConfig);
        JobManagerProcessSpec jobManagerProcessSpec = JobManagerProcessUtils.processSpecFromConfig((Configuration)config);
        Assert.assertThat((Object)jobManagerProcessSpec.getJvmHeapMemorySize(), (Matcher)Matchers.is((Object)JVM_HEAP_SIZE));
        validateFunc.accept(jobManagerProcessSpec);
    }

    private void validateFailInConfigWithExplicitJvmHeap(Configuration customConfig) {
        this.log.info("Validating failing in configuration with explicit jvm heap.");
        Configuration config = JobManagerProcessUtilsTest.configWithExplicitJvmHeap();
        config.addAll(customConfig);
        this.validateFail(config);
    }

    private void validateInConfigWithExplicitTotalFlinkMem(Configuration customConfig, Consumer<JobManagerProcessSpec> validateFunc) {
        this.log.info("Validating in configuration with explicit total flink memory size.");
        Configuration config = JobManagerProcessUtilsTest.configWithExplicitTotalFlinkMem();
        config.addAll(customConfig);
        JobManagerProcessSpec jobManagerProcessSpec = JobManagerProcessUtils.processSpecFromConfig((Configuration)config);
        Assert.assertThat((Object)jobManagerProcessSpec.getTotalFlinkMemorySize(), (Matcher)Matchers.is((Object)TOTAL_FLINK_MEM_SIZE));
        validateFunc.accept(jobManagerProcessSpec);
    }

    private void validateFailInConfigWithExplicitTotalFlinkMem(Configuration customConfig) {
        this.log.info("Validating failing in configuration with explicit total flink memory size.");
        Configuration config = JobManagerProcessUtilsTest.configWithExplicitTotalFlinkMem();
        config.addAll(customConfig);
        this.validateFail(config);
    }

    private void validateInConfigWithExplicitTotalFlinkAndJvmHeapMem(Configuration customConfig, Consumer<JobManagerProcessSpec> validateFunc) {
        this.log.info("Validating in configuration with explicit total flink and jvm heap memory size.");
        Configuration config = JobManagerProcessUtilsTest.configWithExplicitTotalFlinkAndJvmHeapMem();
        config.addAll(customConfig);
        JobManagerProcessSpec jobManagerProcessSpec = JobManagerProcessUtils.processSpecFromConfig((Configuration)config);
        Assert.assertThat((Object)jobManagerProcessSpec.getTotalFlinkMemorySize(), (Matcher)Matchers.is((Object)TOTAL_FLINK_MEM_SIZE));
        Assert.assertThat((Object)jobManagerProcessSpec.getJvmHeapMemorySize(), (Matcher)Matchers.is((Object)JVM_HEAP_SIZE));
        validateFunc.accept(jobManagerProcessSpec);
    }

    private void validateFailInConfigWithExplicitTotalFlinkAndJvmHeapMem(Configuration customConfig) {
        this.log.info("Validating failing in configuration with explicit total flink and jvm heap memory size.");
        Configuration config = JobManagerProcessUtilsTest.configWithExplicitTotalFlinkAndJvmHeapMem();
        config.addAll(customConfig);
        this.validateFail(config);
    }

    private void validateInConfigWithExplicitTotalProcessMem(Configuration customConfig, Consumer<JobManagerProcessSpec> validateFunc) {
        this.log.info("Validating in configuration with explicit total process memory size.");
        Configuration config = JobManagerProcessUtilsTest.configWithExplicitTotalProcessMem();
        config.addAll(customConfig);
        JobManagerProcessSpec jobManagerProcessSpec = JobManagerProcessUtils.processSpecFromConfig((Configuration)config);
        Assert.assertThat((Object)jobManagerProcessSpec.getTotalProcessMemorySize(), (Matcher)Matchers.is((Object)TOTAL_PROCESS_MEM_SIZE));
        validateFunc.accept(jobManagerProcessSpec);
    }

    private void validateFailInConfigWithExplicitTotalProcessMem(Configuration customConfig) {
        this.log.info("Validating failing in configuration with explicit total process memory size.");
        Configuration config = JobManagerProcessUtilsTest.configWithExplicitTotalProcessMem();
        config.addAll(customConfig);
        this.validateFail(config);
    }

    @Override
    protected void validateFail(Configuration config) {
        try {
            JobManagerProcessUtils.processSpecFromConfig((Configuration)config);
            Assert.fail((String)"Configuration did not fail as expected.");
        }
        catch (IllegalConfigurationException illegalConfigurationException) {
            // empty catch block
        }
    }

    @Override
    protected void configWithFineGrainedOptions(Configuration configuration, MemorySize totalFlinkMemorySize) {
        MemorySize heapSize = new MemorySize(totalFlinkMemorySize.getBytes() / 2L);
        MemorySize offHeapSize = totalFlinkMemorySize.subtract(heapSize);
        configuration.set(JobManagerOptions.JVM_HEAP_MEMORY, (Object)heapSize);
        configuration.set(JobManagerOptions.OFF_HEAP_MEMORY, (Object)offHeapSize);
    }

    private static Configuration configWithExplicitJvmHeap() {
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.JVM_HEAP_MEMORY, (Object)JVM_HEAP_SIZE);
        return conf;
    }

    private static Configuration configWithExplicitTotalFlinkMem() {
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.TOTAL_FLINK_MEMORY, (Object)TOTAL_FLINK_MEM_SIZE);
        return conf;
    }

    private static Configuration configWithExplicitTotalFlinkAndJvmHeapMem() {
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.TOTAL_FLINK_MEMORY, (Object)TOTAL_FLINK_MEM_SIZE);
        conf.set(JobManagerOptions.JVM_HEAP_MEMORY, (Object)JVM_HEAP_SIZE);
        return conf;
    }

    private static Configuration configWithExplicitTotalProcessMem() {
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.TOTAL_PROCESS_MEMORY, (Object)TOTAL_PROCESS_MEM_SIZE);
        return conf;
    }
}

