/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.junit.Assert;

public class GenericMessageTester {
    private static final Map<Class<?>, Instantiator<?>> INSTANTIATORS = new HashMap();

    public static void testMessageInstance(Serializable instance) throws Exception {
        Serializable copy = CommonTestUtils.createCopySerializable((Serializable)instance);
        Assert.assertTrue((boolean)instance.equals(copy));
        Assert.assertTrue((boolean)copy.equals(instance));
        Assert.assertTrue((instance.hashCode() == copy.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)instance.toString().equals(copy.toString()));
    }

    public static void testMessageInstances(Serializable instance1, Serializable instance2) throws Exception {
        Assert.assertTrue((boolean)instance1.equals(instance2));
        Assert.assertTrue((boolean)instance2.equals(instance1));
        Assert.assertTrue((instance1.hashCode() == instance2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)instance1.toString().equals(instance2.toString()));
        Serializable copy = CommonTestUtils.createCopySerializable((Serializable)instance1);
        Assert.assertTrue((boolean)instance1.equals(copy));
        Assert.assertTrue((boolean)copy.equals(instance1));
        Assert.assertTrue((instance1.hashCode() == copy.hashCode() ? 1 : 0) != 0);
    }

    public static <T> T instantiateGeneric(Class<T> messageClass, Random rnd, Instantiator<?> ... extraInstantiators) {
        try {
            HashMap extraInsts = new HashMap();
            for (Instantiator<?> inst : extraInstantiators) {
                Class type = (Class)((ParameterizedType)inst.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
                Assert.assertNotNull((String)"Cannot get type for extra instantiator", (Object)type);
                extraInsts.put(type, inst);
            }
            Constructor<?>[] constructors = messageClass.getConstructors();
            Class<?> missingType = null;
            for (Constructor<?> constructor : constructors) {
                int i;
                Class<?>[] paramTypes;
                block7: {
                    paramTypes = constructor.getParameterTypes();
                    Object[] params = new Object[paramTypes.length];
                    for (i = 0; i < paramTypes.length; ++i) {
                        Instantiator<?> inst = (Instantiator<?>)extraInsts.get(paramTypes[i]);
                        if (inst == null) {
                            inst = INSTANTIATORS.get(paramTypes[i]);
                        }
                        if (inst != null) {
                            params[i] = inst.instantiate(rnd);
                            continue;
                        }
                        break block7;
                    }
                    return (T)constructor.newInstance(params);
                }
                missingType = paramTypes[i];
            }
            Assert.fail((String)("No instantiator available for type " + missingType.getCanonicalName()));
            throw new RuntimeException();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Could not perform reflective tests: " + e.getMessage()));
            throw new RuntimeException();
        }
    }

    public static String randomString(Random rnd) {
        int len = rnd.nextInt(65);
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)rnd.nextInt();
        }
        return new String(chars);
    }

    public static JobID randomJobId(Random rnd) {
        return new JobID(rnd.nextLong(), rnd.nextLong());
    }

    public static JobStatus randomJobStatus(Random rnd) {
        return JobStatus.values()[rnd.nextInt(JobStatus.values().length)];
    }

    static {
        INSTANTIATORS.put(Boolean.TYPE, new BooleanInstantiator());
        INSTANTIATORS.put(Boolean.class, new BooleanInstantiator());
        INSTANTIATORS.put(Character.TYPE, new CharInstantiator());
        INSTANTIATORS.put(Character.class, new CharInstantiator());
        INSTANTIATORS.put(Byte.TYPE, new ByteInstantiator());
        INSTANTIATORS.put(Byte.class, new ByteInstantiator());
        INSTANTIATORS.put(Short.TYPE, new ShortInstantiator());
        INSTANTIATORS.put(Short.class, new ShortInstantiator());
        INSTANTIATORS.put(Integer.TYPE, new IntInstantiator());
        INSTANTIATORS.put(Integer.class, new IntInstantiator());
        INSTANTIATORS.put(Long.TYPE, new LongInstantiator());
        INSTANTIATORS.put(Long.class, new LongInstantiator());
        INSTANTIATORS.put(Float.TYPE, new FloatInstantiator());
        INSTANTIATORS.put(Float.class, new FloatInstantiator());
        INSTANTIATORS.put(Double.TYPE, new DoubleInstantiator());
        INSTANTIATORS.put(Double.class, new DoubleInstantiator());
        INSTANTIATORS.put(String.class, new StringInstantiator());
        INSTANTIATORS.put(JobID.class, new JobIdInstantiator());
        INSTANTIATORS.put(JobStatus.class, new JobStatusInstantiator());
    }

    public static class JobStatusInstantiator
    implements Instantiator<JobStatus> {
        @Override
        public JobStatus instantiate(Random rnd) {
            return GenericMessageTester.randomJobStatus(rnd);
        }
    }

    public static class JobIdInstantiator
    implements Instantiator<JobID> {
        @Override
        public JobID instantiate(Random rnd) {
            return GenericMessageTester.randomJobId(rnd);
        }
    }

    public static class StringInstantiator
    implements Instantiator<String> {
        @Override
        public String instantiate(Random rnd) {
            return GenericMessageTester.randomString(rnd);
        }
    }

    public static class CharInstantiator
    implements Instantiator<Character> {
        @Override
        public Character instantiate(Random rnd) {
            return Character.valueOf((char)rnd.nextInt(30000));
        }
    }

    public static class BooleanInstantiator
    implements Instantiator<Boolean> {
        @Override
        public Boolean instantiate(Random rnd) {
            return rnd.nextBoolean();
        }
    }

    public static class DoubleInstantiator
    implements Instantiator<Double> {
        @Override
        public Double instantiate(Random rnd) {
            return rnd.nextDouble();
        }
    }

    public static class FloatInstantiator
    implements Instantiator<Float> {
        @Override
        public Float instantiate(Random rnd) {
            return Float.valueOf(rnd.nextFloat());
        }
    }

    public static class LongInstantiator
    implements Instantiator<Long> {
        @Override
        public Long instantiate(Random rnd) {
            return rnd.nextInt(Integer.MAX_VALUE);
        }
    }

    public static class IntInstantiator
    implements Instantiator<Integer> {
        @Override
        public Integer instantiate(Random rnd) {
            return rnd.nextInt(Integer.MAX_VALUE);
        }
    }

    public static class ShortInstantiator
    implements Instantiator<Short> {
        @Override
        public Short instantiate(Random rnd) {
            return (short)rnd.nextInt(30000);
        }
    }

    public static class ByteInstantiator
    implements Instantiator<Byte> {
        @Override
        public Byte instantiate(Random rnd) {
            int i = rnd.nextInt(100);
            return (byte)i;
        }
    }

    public static interface Instantiator<T> {
        public T instantiate(Random var1);
    }
}

