/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.dump;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.metrics.util.TestHistogram;
import org.apache.flink.runtime.metrics.dump.MetricDump;
import org.apache.flink.runtime.metrics.dump.MetricDumpSerialization;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;

class MetricDumpSerializerTest {
    MetricDumpSerializerTest() {
    }

    @Test
    void testNullGaugeHandling() throws IOException {
        MetricDumpSerialization.MetricDumpSerializer serializer = new MetricDumpSerialization.MetricDumpSerializer();
        MetricDumpSerialization.MetricDumpDeserializer deserializer = new MetricDumpSerialization.MetricDumpDeserializer();
        HashMap<1, Tuple2> gauges = new HashMap<1, Tuple2>();
        gauges.put(new Gauge<Object>(){

            public Object getValue() {
                return null;
            }
        }, new Tuple2((Object)new QueryScopeInfo.JobManagerQueryScopeInfo("A"), (Object)"g"));
        MetricDumpSerialization.MetricSerializationResult output = serializer.serialize(Collections.emptyMap(), gauges, Collections.emptyMap(), Collections.emptyMap());
        Assertions.assertThat((byte[])output.serializedCounters).isEmpty();
        Assertions.assertThat((byte[])output.serializedGauges).isEmpty();
        Assertions.assertThat((byte[])output.serializedHistograms).isEmpty();
        Assertions.assertThat((byte[])output.serializedMeters).isEmpty();
        List deserialized = deserializer.deserialize(output);
        Assertions.assertThat((List)deserialized).isEmpty();
    }

    @Test
    void testJavaSerialization() throws IOException {
        MetricDumpSerialization.MetricDumpSerializer serializer = new MetricDumpSerialization.MetricDumpSerializer();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(serializer.serialize(new HashMap(), new HashMap(), new HashMap(), new HashMap()));
    }

    @Test
    void testSerialization() throws IOException {
        MetricDumpSerialization.MetricDumpSerializer serializer = new MetricDumpSerialization.MetricDumpSerializer();
        MetricDumpSerialization.MetricDumpDeserializer deserializer = new MetricDumpSerialization.MetricDumpDeserializer();
        HashMap<SimpleCounter, Tuple2> counters = new HashMap<SimpleCounter, Tuple2>();
        HashMap<2, Tuple2> gauges = new HashMap<2, Tuple2>();
        HashMap<TestHistogram, Tuple2> histograms = new HashMap<TestHistogram, Tuple2>();
        HashMap<3, Tuple2> meters = new HashMap<3, Tuple2>();
        SimpleCounter c1 = new SimpleCounter();
        SimpleCounter c2 = new SimpleCounter();
        c1.inc(1L);
        c2.inc(2L);
        Gauge<Integer> g1 = new Gauge<Integer>(){

            public Integer getValue() {
                return 4;
            }
        };
        TestHistogram h1 = new TestHistogram();
        Meter m1 = new Meter(){

            public void markEvent() {
            }

            public void markEvent(long n) {
            }

            public double getRate() {
                return 5.0;
            }

            public long getCount() {
                return 10L;
            }
        };
        counters.put(c1, new Tuple2((Object)new QueryScopeInfo.JobManagerQueryScopeInfo("A"), (Object)"c1"));
        counters.put(c2, new Tuple2((Object)new QueryScopeInfo.TaskManagerQueryScopeInfo("tmid", "B"), (Object)"c2"));
        meters.put(m1, new Tuple2((Object)new QueryScopeInfo.JobQueryScopeInfo("jid", "C"), (Object)"c3"));
        gauges.put(g1, new Tuple2((Object)new QueryScopeInfo.TaskQueryScopeInfo("jid", "vid", 2, 0, "D"), (Object)"g1"));
        histograms.put(h1, new Tuple2((Object)new QueryScopeInfo.OperatorQueryScopeInfo("jid", "vid", 2, 0, "opname", "E"), (Object)"h1"));
        MetricDumpSerialization.MetricSerializationResult serialized = serializer.serialize(counters, gauges, histograms, meters);
        List deserialized = deserializer.deserialize(serialized);
        Assertions.assertThat((int)deserialized.size()).isEqualTo(5);
        block10: for (MetricDump metric : deserialized) {
            switch (metric.getCategory()) {
                case 0: {
                    MetricDump.CounterDump counterDump = (MetricDump.CounterDump)metric;
                    switch ((byte)counterDump.count) {
                        case 1: {
                            Assertions.assertThat((Object)counterDump.scopeInfo).isInstanceOf(QueryScopeInfo.JobManagerQueryScopeInfo.class);
                            Assertions.assertThat((String)counterDump.scopeInfo.scope).isEqualTo("A");
                            Assertions.assertThat((String)counterDump.name).isEqualTo("c1");
                            counters.remove(c1);
                            continue block10;
                        }
                        case 2: {
                            Assertions.assertThat((Object)counterDump.scopeInfo).isInstanceOf(QueryScopeInfo.TaskManagerQueryScopeInfo.class);
                            Assertions.assertThat((String)counterDump.scopeInfo.scope).isEqualTo("B");
                            Assertions.assertThat((String)counterDump.name).isEqualTo("c2");
                            Assertions.assertThat((String)"tmid").isEqualTo(((QueryScopeInfo.TaskManagerQueryScopeInfo)counterDump.scopeInfo).taskManagerID);
                            counters.remove(c2);
                            continue block10;
                        }
                    }
                    Assertions.fail((String)"Unexpected counter count.");
                    continue block10;
                }
                case 1: {
                    MetricDump.GaugeDump gaugeDump = (MetricDump.GaugeDump)metric;
                    Assertions.assertThat((String)gaugeDump.value).isEqualTo("4");
                    Assertions.assertThat((String)gaugeDump.name).isEqualTo("g1");
                    Assertions.assertThat((Object)gaugeDump.scopeInfo).isInstanceOf(QueryScopeInfo.TaskQueryScopeInfo.class);
                    QueryScopeInfo.TaskQueryScopeInfo taskInfo = (QueryScopeInfo.TaskQueryScopeInfo)gaugeDump.scopeInfo;
                    Assertions.assertThat((String)taskInfo.scope).isEqualTo("D");
                    Assertions.assertThat((String)taskInfo.jobID).isEqualTo("jid");
                    Assertions.assertThat((String)taskInfo.vertexID).isEqualTo("vid");
                    Assertions.assertThat((int)taskInfo.subtaskIndex).isEqualTo(2);
                    gauges.remove(g1);
                    continue block10;
                }
                case 2: {
                    MetricDump.HistogramDump histogramDump = (MetricDump.HistogramDump)metric;
                    Assertions.assertThat((String)histogramDump.name).isEqualTo("h1");
                    Assertions.assertThat((double)histogramDump.median).isCloseTo(0.5, Offset.offset((Number)0.1));
                    Assertions.assertThat((double)histogramDump.p75).isCloseTo(0.75, Offset.offset((Number)0.1));
                    Assertions.assertThat((double)histogramDump.p90).isCloseTo(0.9, Offset.offset((Number)0.1));
                    Assertions.assertThat((double)histogramDump.p95).isCloseTo(0.95, Offset.offset((Number)0.1));
                    Assertions.assertThat((double)histogramDump.p98).isCloseTo(0.98, Offset.offset((Number)0.1));
                    Assertions.assertThat((double)histogramDump.p99).isCloseTo(0.99, Offset.offset((Number)0.1));
                    Assertions.assertThat((double)histogramDump.p999).isCloseTo(0.999, Offset.offset((Number)0.1));
                    Assertions.assertThat((double)histogramDump.mean).isCloseTo(4.0, Offset.offset((Number)0.1));
                    Assertions.assertThat((double)histogramDump.stddev).isCloseTo(5.0, Offset.offset((Number)0.1));
                    Assertions.assertThat((long)histogramDump.max).isEqualTo(6L);
                    Assertions.assertThat((long)histogramDump.min).isEqualTo(7L);
                    Assertions.assertThat((Object)histogramDump.scopeInfo).isInstanceOf(QueryScopeInfo.OperatorQueryScopeInfo.class);
                    QueryScopeInfo.OperatorQueryScopeInfo opInfo = (QueryScopeInfo.OperatorQueryScopeInfo)histogramDump.scopeInfo;
                    Assertions.assertThat((String)opInfo.scope).isEqualTo("E");
                    Assertions.assertThat((String)opInfo.jobID).isEqualTo("jid");
                    Assertions.assertThat((String)opInfo.vertexID).isEqualTo("vid");
                    Assertions.assertThat((int)opInfo.subtaskIndex).isEqualTo(2);
                    Assertions.assertThat((String)opInfo.operatorName).isEqualTo("opname");
                    histograms.remove(h1);
                    continue block10;
                }
                case 3: {
                    MetricDump.MeterDump meterDump = (MetricDump.MeterDump)metric;
                    Assertions.assertThat((double)meterDump.rate).isCloseTo(5.0, Offset.offset((Number)0.1));
                    Assertions.assertThat((Object)meterDump.scopeInfo).isInstanceOf(QueryScopeInfo.JobQueryScopeInfo.class);
                    Assertions.assertThat((String)meterDump.scopeInfo.scope).isEqualTo("C");
                    Assertions.assertThat((String)meterDump.name).isEqualTo("c3");
                    Assertions.assertThat((String)((QueryScopeInfo.JobQueryScopeInfo)meterDump.scopeInfo).jobID).isEqualTo("jid");
                    continue block10;
                }
            }
            Assertions.fail((String)("Unexpected metric type: " + metric.getCategory()));
        }
        Assertions.assertThat(counters).isEmpty();
        Assertions.assertThat(gauges).isEmpty();
        Assertions.assertThat(histograms).isEmpty();
    }
}

