/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.compatibility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.runtime.rest.compatibility.Compatibility;

final class CompatibilityCheckResult {
    private final Compatibility backwardCompatibility;
    private final int backwardCompatibilityGrade;
    private final Collection<AssertionError> backwardCompatibilityErrors;

    private CompatibilityCheckResult(Compatibility backwardCompatibility) {
        this(backwardCompatibility, 1, Collections.emptyList());
        if (backwardCompatibility == Compatibility.INCOMPATIBLE) {
            throw new RuntimeException("This constructor must not be used for incompatible results.");
        }
    }

    private CompatibilityCheckResult(Compatibility backwardCompatibility, int backwardCompatibilityGrade, Collection<AssertionError> backwardCompatibilityErrors) {
        this.backwardCompatibility = backwardCompatibility;
        this.backwardCompatibilityGrade = backwardCompatibilityGrade;
        this.backwardCompatibilityErrors = Collections.unmodifiableCollection(backwardCompatibilityErrors);
    }

    public Compatibility getBackwardCompatibility() {
        return this.backwardCompatibility;
    }

    public int getBackwardCompatibilityGrade() {
        return this.backwardCompatibilityGrade;
    }

    public Collection<AssertionError> getBackwardCompatibilityErrors() {
        return this.backwardCompatibilityErrors;
    }

    CompatibilityCheckResult merge(CompatibilityCheckResult other) {
        Compatibility mergedCompatibility = this.backwardCompatibility.merge(other.backwardCompatibility);
        int mergedGrade = this.backwardCompatibilityGrade + other.backwardCompatibilityGrade;
        ArrayList<AssertionError> mergedErrors = new ArrayList<AssertionError>(this.backwardCompatibilityErrors.size() + other.backwardCompatibilityErrors.size());
        mergedErrors.addAll(this.backwardCompatibilityErrors);
        mergedErrors.addAll(other.backwardCompatibilityErrors);
        return new CompatibilityCheckResult(mergedCompatibility, mergedGrade, mergedErrors);
    }

    public static CompatibilityCheckResult identical() {
        return new CompatibilityCheckResult(Compatibility.IDENTICAL);
    }

    public static CompatibilityCheckResult compatible() {
        return new CompatibilityCheckResult(Compatibility.COMPATIBLE);
    }

    public static CompatibilityCheckResult incompatible(AssertionError backwardCompatibilityError) {
        return new CompatibilityCheckResult(Compatibility.INCOMPATIBLE, 0, Collections.singletonList(backwardCompatibilityError));
    }
}

