/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.scheduler.adaptive.BackgroundTask;
import org.apache.flink.testutils.executor.TestExecutorResource;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class BackgroundTaskTest
extends TestLogger {
    @ClassRule
    public static final TestExecutorResource<ExecutorService> TEST_EXECUTOR_RESOURCE = new TestExecutorResource(() -> Executors.newFixedThreadPool(2));

    @Test
    public void testFinishedBackgroundTaskIsTerminated() {
        BackgroundTask finishedBackgroundTask = BackgroundTask.finishedBackgroundTask();
        Assert.assertTrue((boolean)finishedBackgroundTask.getTerminationFuture().isDone());
        finishedBackgroundTask.getTerminationFuture().join();
    }

    @Test
    public void testFinishedBackgroundTaskDoesNotContainAResult() {
        BackgroundTask finishedBackgroundTask = BackgroundTask.finishedBackgroundTask();
        Assert.assertTrue((boolean)finishedBackgroundTask.getResultFuture().isCompletedExceptionally());
    }

    @Test
    public void testNormalCompletionOfBackgroundTask() {
        String expectedValue = "foobar";
        BackgroundTask backgroundTask = BackgroundTask.finishedBackgroundTask().runAfter(() -> "foobar", (Executor)TEST_EXECUTOR_RESOURCE.getExecutor());
        Assert.assertThat(backgroundTask.getResultFuture().join(), (Matcher)Matchers.is((Object)"foobar"));
        backgroundTask.getTerminationFuture().join();
    }

    @Test
    public void testExceptionalCompletionOfBackgroundTask() throws InterruptedException {
        Exception expectedException = new Exception("Test exception");
        BackgroundTask backgroundTask = BackgroundTask.finishedBackgroundTask().runAfter(() -> {
            throw expectedException;
        }, (Executor)TEST_EXECUTOR_RESOURCE.getExecutor());
        try {
            backgroundTask.getResultFuture().get();
            Assert.fail((String)"Expected an exceptionally completed result future.");
        }
        catch (ExecutionException ee) {
            Assert.assertThat((Object)ee, (Matcher)FlinkMatchers.containsCause((Throwable)expectedException));
        }
        backgroundTask.getTerminationFuture().join();
    }

    @Test
    public void testRunAfterExecutesBackgroundTaskAfterPreviousHasCompleted() {
        OneShotLatch blockingLatch = new OneShotLatch();
        ArrayBlockingQueue taskCompletions = new ArrayBlockingQueue(2);
        BackgroundTask backgroundTask = BackgroundTask.initialBackgroundTask(() -> {
            blockingLatch.await();
            taskCompletions.offer(1);
            return null;
        }, (Executor)TEST_EXECUTOR_RESOURCE.getExecutor()).runAfter(() -> {
            taskCompletions.offer(2);
            return null;
        }, (Executor)TEST_EXECUTOR_RESOURCE.getExecutor());
        blockingLatch.trigger();
        backgroundTask.getTerminationFuture().join();
        Assert.assertThat(taskCompletions, (Matcher)Matchers.contains((Object[])new Integer[]{1, 2}));
    }

    @Test
    public void testAbortSkipsTasksWhichHaveNotBeenStarted() {
        OneShotLatch blockingLatch = new OneShotLatch();
        ArrayBlockingQueue taskCompletions = new ArrayBlockingQueue(2);
        BackgroundTask backgroundTask = BackgroundTask.initialBackgroundTask(() -> {
            blockingLatch.await();
            taskCompletions.offer(1);
            return null;
        }, (Executor)TEST_EXECUTOR_RESOURCE.getExecutor()).runAfter(() -> {
            taskCompletions.offer(2);
            return null;
        }, (Executor)TEST_EXECUTOR_RESOURCE.getExecutor());
        BackgroundTask finalTask = backgroundTask.runAfter(() -> {
            taskCompletions.offer(3);
            return null;
        }, (Executor)TEST_EXECUTOR_RESOURCE.getExecutor());
        backgroundTask.abort();
        blockingLatch.trigger();
        finalTask.getTerminationFuture().join();
        Assert.assertThat(taskCompletions, (Matcher)Matchers.contains((Object[])new Integer[]{1, 3}));
    }
}

