/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.TaskExecutionStateTransition;
import org.apache.flink.runtime.scheduler.ExecutionGraphHandler;
import org.apache.flink.runtime.scheduler.OperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.Canceling;
import org.apache.flink.runtime.scheduler.adaptive.ExecutingTest;
import org.apache.flink.runtime.scheduler.adaptive.MockStateWithExecutionGraphContext;
import org.apache.flink.runtime.scheduler.adaptive.StateTrackingMockExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.StateWithExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.TestingOperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.exceptionhistory.TestingAccessExecution;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class CancelingTest
extends TestLogger {
    @Test
    public void testExecutionGraphCancelationOnEnter() throws Exception {
        try (MockStateWithExecutionGraphContext ctx = new MockStateWithExecutionGraphContext();){
            StateTrackingMockExecutionGraph stateTrackingMockExecutionGraph = new StateTrackingMockExecutionGraph();
            this.createCancelingState(ctx, stateTrackingMockExecutionGraph);
            Assert.assertThat((Object)stateTrackingMockExecutionGraph.getState(), (Matcher)CoreMatchers.is((Object)JobStatus.CANCELLING));
        }
    }

    @Test
    public void testTransitionToFinishedWhenCancellationCompletes() throws Exception {
        try (MockStateWithExecutionGraphContext ctx = new MockStateWithExecutionGraphContext();){
            StateTrackingMockExecutionGraph stateTrackingMockExecutionGraph = new StateTrackingMockExecutionGraph();
            Canceling canceling = this.createCancelingState(ctx, stateTrackingMockExecutionGraph);
            Assert.assertThat((Object)stateTrackingMockExecutionGraph.getState(), (Matcher)CoreMatchers.is((Object)JobStatus.CANCELLING));
            ctx.setExpectFinished(archivedExecutionGraph -> Assert.assertThat((Object)archivedExecutionGraph.getState(), (Matcher)CoreMatchers.is((Object)JobStatus.CANCELED)));
            stateTrackingMockExecutionGraph.completeTerminationFuture(JobStatus.CANCELED);
        }
    }

    @Test
    public void testTransitionToSuspend() throws Exception {
        try (MockStateWithExecutionGraphContext ctx = new MockStateWithExecutionGraphContext();){
            Canceling canceling = this.createCancelingState(ctx, new StateTrackingMockExecutionGraph());
            ctx.setExpectFinished(archivedExecutionGraph -> Assert.assertThat((Object)archivedExecutionGraph.getState(), (Matcher)CoreMatchers.is((Object)JobStatus.SUSPENDED)));
            canceling.suspend((Throwable)new RuntimeException("suspend"));
        }
    }

    @Test
    public void testCancelIsIgnored() throws Exception {
        try (MockStateWithExecutionGraphContext ctx = new MockStateWithExecutionGraphContext();){
            Canceling canceling = this.createCancelingState(ctx, new StateTrackingMockExecutionGraph());
            canceling.cancel();
            ctx.assertNoStateTransition();
        }
    }

    @Test
    public void testGlobalFailuresAreIgnored() throws Exception {
        try (MockStateWithExecutionGraphContext ctx = new MockStateWithExecutionGraphContext();){
            Canceling canceling = this.createCancelingState(ctx, new StateTrackingMockExecutionGraph());
            canceling.handleGlobalFailure((Throwable)new RuntimeException("test"));
            ctx.assertNoStateTransition();
        }
    }

    @Test
    public void testTaskFailuresAreIgnored() throws Exception {
        try (MockStateWithExecutionGraphContext ctx = new MockStateWithExecutionGraphContext();){
            StateTrackingMockExecutionGraph meg = new StateTrackingMockExecutionGraph();
            Canceling canceling = this.createCancelingState(ctx, meg);
            RuntimeException exception = new RuntimeException();
            TestingAccessExecution execution = TestingAccessExecution.newBuilder().withExecutionState(ExecutionState.FAILED).withErrorInfo(new ErrorInfo((Throwable)exception, System.currentTimeMillis())).build();
            meg.registerExecution(execution);
            TaskExecutionStateTransition update = ExecutingTest.createFailingStateTransition(execution.getAttemptId(), exception);
            canceling.updateTaskExecutionState(update);
            ctx.assertNoStateTransition();
        }
    }

    @Test
    public void testStateDoesNotExposeGloballyTerminalExecutionGraph() throws Exception {
        try (MockStateWithExecutionGraphContext ctx = new MockStateWithExecutionGraphContext();){
            StateTrackingMockExecutionGraph meg = new StateTrackingMockExecutionGraph();
            Canceling canceling = this.createCancelingState(ctx, meg);
            ctx.setExpectFinished(eg -> {});
            meg.completeTerminationFuture(JobStatus.CANCELED);
            Assert.assertThat((Object)meg.getState(), (Matcher)CoreMatchers.is((Object)JobStatus.CANCELED));
            Assert.assertThat((Object)canceling.getJobStatus(), (Matcher)CoreMatchers.is((Object)JobStatus.CANCELLING));
            Assert.assertThat((Object)canceling.getJob().getState(), (Matcher)CoreMatchers.is((Object)JobStatus.CANCELLING));
            Assert.assertThat((Object)canceling.getJob().getStatusTimestamp(JobStatus.CANCELED), (Matcher)CoreMatchers.is((Object)0L));
        }
    }

    private Canceling createCancelingState(MockStateWithExecutionGraphContext ctx, ExecutionGraph executionGraph) {
        ExecutionGraphHandler executionGraphHandler = new ExecutionGraphHandler(executionGraph, this.log, (Executor)ctx.getMainThreadExecutor(), ctx.getMainThreadExecutor());
        TestingOperatorCoordinatorHandler operatorCoordinatorHandler = new TestingOperatorCoordinatorHandler();
        executionGraph.transitionToRunning();
        Canceling canceling = new Canceling((StateWithExecutionGraph.Context)ctx, executionGraph, executionGraphHandler, (OperatorCoordinatorHandler)operatorCoordinatorHandler, this.log, ClassLoader.getSystemClassLoader(), new ArrayList());
        return canceling;
    }
}

